/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.item.file.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.bean.CoreFileCkeditorUploadResultDTO;
import net.sinodawn.module.item.file.bean.CoreFileImportResultDTO;
import net.sinodawn.module.item.file.bean.CoreFileLogBean;
import net.sinodawn.module.item.file.bean.CoreFileOfficeResultDTO;
import net.sinodawn.module.item.file.service.CoreFileService;
import java.io.Serializable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping({"/core/module/item/files"})
public interface CoreFileResource extends GenericResource<CoreFileService, CoreFileBean, Long> {
   @RequestMapping(
      method = {RequestMethod.POST}
   )
   Long upload(CoreFileBean coreFile, MultipartFile file);

   @RequestMapping(
      method = {RequestMethod.DELETE}
   )
   void delete(RestJsonWrapperBean wrapper);

   @RequestMapping(
      method = {RequestMethod.PUT}
   )
   void save(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/pack/{table}/{itemId}", "/action/pack/{table}/{itemId}/add-on-func/{func}"},
      method = {RequestMethod.POST}
   )
   String pack(@PathVariable String table, @PathVariable String itemId, @PathVariable(required = false) String func);

   @RequestMapping(
      value = {"/action/pack/{table}"},
      method = {RequestMethod.POST}
   )
   String pack(@PathVariable String table, RestJsonWrapperBean jsonWrapper);

   @RequestMapping(
      value = {"/action/pack"},
      method = {RequestMethod.POST}
   )
   String pack(RestJsonWrapperBean jsonWrapper);

   @RequestMapping(
      value = {"/action/ckeditor-upload"},
      method = {RequestMethod.POST}
   )
   CoreFileCkeditorUploadResultDTO ckeditorUpload(CoreFileBean coreFile, MultipartFile file);

   @RequestMapping(
      value = {"/{id}/action/import/{service}"},
      method = {RequestMethod.POST}
   )
   CoreFileImportResultDTO importData(@PathVariable Long id, @PathVariable String service);

   @RequestMapping(
      value = {"/template-urls"},
      method = {RequestMethod.GET}
   )
   <ID extends Serializable> String getTemplateUrl(@RequestParam String templateCode, @RequestParam String service, @RequestParam(required = false) ID id);

   @RequestMapping(
      value = {"/{id}/logs"},
      method = {RequestMethod.POST}
   )
   Long log(@PathVariable Long id, @RequestParam String operationCategory);

   @RequestMapping(
      value = {"/{id}/logs/queries/searchable"},
      method = {RequestMethod.POST}
   )
   Page<CoreFileLogBean> selectLogSearchablePagination(Long id, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/convert-html-to-pdf"},
      method = {RequestMethod.POST}
   )
   String convertHtmlToPdf(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/action/sinooffice-invoke"},
      method = {RequestMethod.POST}
   )
   CoreFileOfficeResultDTO sinoOfficeInvoke(@PathVariable Long id);

   /** @deprecated */
   @Deprecated
   @RequestMapping(
      value = {"/{templateCode}/action/download-template/{service}", "/{templateCode}/action/download-template/{service}/{id}"},
      method = {RequestMethod.GET}
   )
   <ID extends Serializable> String getDownloadTemplateUrl(@PathVariable String templateCode, @PathVariable String service, @PathVariable(required = false) ID id);

   /** @deprecated */
   @Deprecated
   @RequestMapping(
      value = {"/{id}/logs/action/{operationCategory}"},
      method = {RequestMethod.POST}
   )
   Long oldLog(@PathVariable Long id, @PathVariable String operationCategory);

   /** @deprecated */
   @Deprecated
   @RequestMapping(
      value = {"/sinooffices/{id}/action/invoke"},
      method = {RequestMethod.POST}
   )
   CoreFileOfficeResultDTO oldSinoOfficeInvoke(@PathVariable Long id);
}
