/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.item.file.manager;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.io.file.FilePathDTO;
import net.sinodawn.framework.io.file.FilePathManager;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.service.CoreFileService;
import net.sinodawn.module.item.file.utils.CoreFileUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;

public interface CoreFileManager {
   default String getDownloadUrl(Long id) {
      CoreFileBean coreFile = (CoreFileBean)((CoreFileService)ApplicationContextHelper.getBean(CoreFileService.class)).selectByIdIfPresent(id);
      return coreFile == null ? null : this.getDownloadUrl(coreFile);
   }

   default String getAbsoluteDownloadUrl(Long id) {
      CoreFileBean coreFile = (CoreFileBean)((CoreFileService)ApplicationContextHelper.getBean(CoreFileService.class)).selectByIdIfPresent(id);
      return coreFile == null ? null : this.getAbsoluteDownloadUrl(coreFile);
   }

   default String getDownloadUrl(CoreFileBean coreFile) {
      return this.getDownloadUrl(CoreFileUtils.toFilePath(coreFile));
   }

   default String getAbsoluteDownloadUrl(CoreFileBean coreFile) {
      return this.getAbsoluteDownloadUrl(CoreFileUtils.toFilePath(coreFile));
   }

   String getDownloadUrl(FilePathDTO filePath);

   String getAbsoluteDownloadUrl(FilePathDTO filePath);

   default void upload(CoreFileBean coreFile, MultipartFile multipartFile) {
      this.upload(CoreFileUtils.toFilePath(coreFile), multipartFile);
   }

   default void upload(CoreFileBean coreFile, Path path) {
      this.upload(CoreFileUtils.toFilePath(coreFile), path);
   }

   default void upload(CoreFileBean coreFile, File file) {
      this.upload(CoreFileUtils.toFilePath(coreFile), file);
   }

   default void upload(CoreFileBean coreFile, InputStream is) {
      this.upload(CoreFileUtils.toFilePath(coreFile), is);
   }

   void upload(FilePathDTO filePath, MultipartFile multipartFile);

   void upload(FilePathDTO filePath, Path path);

   default void upload(FilePathDTO filePath, File file) {
      this.upload(filePath, file.toPath());
   }

   void upload(FilePathDTO filePath, InputStream is);

   void download(FilePathDTO filePath, Path toFile);

   default void download(FilePathDTO filePath) {
      this.download(filePath, FilePathManager.getLocalPath(filePath));
   }

   default void download(CoreFileBean coreFile, Path toFile) {
      this.download(CoreFileUtils.toFilePath(coreFile), toFile);
   }

   default void download(CoreFileBean coreFile) {
      this.download(coreFile, FilePathManager.getLocalPath(CoreFileUtils.toFilePath(coreFile)));
   }

   void copyFile(FilePathDTO fromFilePath, FilePathDTO toFilePath);

   default void copyFile(CoreFileBean from, CoreFileBean to) {
      this.copyFile(CoreFileUtils.toFilePath(from), CoreFileUtils.toFilePath(to));
   }

   void duplicateFile(CoreFileBean from, String toFileName);
}
