/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.item.file.function;

import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.bean.CoreFileImportResultDTO;
import net.sinodawn.module.item.file.utils.CoreFileUtils;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public interface CoreFileImportFunction extends Function<CoreFileBean, CoreFileImportResultDTO>, BiPredicate<CoreFileBean, String> {
   default boolean test(CoreFileBean coreFile, String service) {
      Path path = CoreFileUtils.getLocalPath(coreFile);

      try {
         InputStream is = Files.newInputStream(path);
         Throwable var5 = null;

         boolean var13;
         try {
            Workbook wb = WorkbookFactory.create(is);
            Throwable var7 = null;

            try {
               Sheet sheet = (HSSFSheet)wb.getSheetAt(0);
               Row row = sheet.getRow(0);
               Cell cell = row.getCell(0);
               Comment comment = cell.getCellComment();
               String tempName = comment.getString().getString();
               if (service.substring(0, service.lastIndexOf("ImportFileFunction")).indexOf(tempName) < 0 && service.substring(0, service.lastIndexOf("FileImportFunction")).indexOf(tempName) < 0) {
                  return false;
               }

               var13 = true;
            } catch (Throwable var41) {
               var7 = var41;
               throw var41;
            } finally {
               if (wb != null) {
                  if (var7 != null) {
                     try {
                        wb.close();
                     } catch (Throwable var40) {
                        var7.addSuppressed(var40);
                     }
                  } else {
                     wb.close();
                  }
               }

            }
         } catch (Throwable var43) {
            var5 = var43;
            throw var43;
         } finally {
            if (is != null) {
               if (var5 != null) {
                  try {
                     is.close();
                  } catch (Throwable var39) {
                     var5.addSuppressed(var39);
                  }
               } else {
                  is.close();
               }
            }

         }

         return var13;
      } catch (Exception var45) {
         return false;
      }
   }
}
