/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.item.file.bean;

import com.alibaba.fastjson.annotation.JSONField;
import org.springframework.data.annotation.Id;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;
import java.time.LocalDateTime;
import org.springframework.format.annotation.DateTimeFormat;

@Table("T_CORE_FILE_LOG")
public class CoreFileLogBean extends AbstractInsertable<Long> implements Insertable<Long> {
   private static final long serialVersionUID = 3573091147906198116L;
   @Id
   private Long id;
   private Long fileId;
   private String operationCategory;
   private String createdById;
   private String createdByName;
   @JSONField(
      format = "yyyy-MM-dd"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime createdTime;
   private String createdByOrgId;
   private String createdByOrgName;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public Long getFileId() {
      return this.fileId;
   }

   public void setFileId(Long fileId) {
      this.fileId = fileId;
   }

   public String getOperationCategory() {
      return this.operationCategory;
   }

   public void setOperationCategory(String operationCategory) {
      this.operationCategory = operationCategory;
   }

   public String getCreatedById() {
      return this.createdById;
   }

   public void setCreatedById(String createdById) {
      this.createdById = createdById;
   }

   public String getCreatedByName() {
      return this.createdByName;
   }

   public void setCreatedByName(String createdByName) {
      this.createdByName = createdByName;
   }

   public LocalDateTime getCreatedTime() {
      return this.createdTime;
   }

   public void setCreatedTime(LocalDateTime createdTime) {
      this.createdTime = createdTime;
   }

   public String getCreatedByOrgId() {
      return this.createdByOrgId;
   }

   public void setCreatedByOrgId(String createdByOrgId) {
      this.createdByOrgId = createdByOrgId;
   }

   public String getCreatedByOrgName() {
      return this.createdByOrgName;
   }

   public void setCreatedByOrgName(String createdByOrgName) {
      this.createdByOrgName = createdByOrgName;
   }
}
