/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.hello.service.impl;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.module.hello.dao.SinoHelloDao;
import net.sinodawn.module.hello.service.SinoHelloService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SinoHelloServiceImpl implements SinoHelloService {

    @Autowired
    SinoHelloDao sinoHelloDao;

    @Override
    @SuppressWarnings("unchecked")
    public SinoHelloDao getDao() {
        return sinoHelloDao;
    }

    @Override
    public String getContextBeans() {
        return String.join("\n", ApplicationContextHelper.getApplicationContext().getBeanDefinitionNames());
    }
}
