/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.admin.request.service.impl;

import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.admin.request.bean.CoreRequestUrlBean;
import net.sinodawn.module.admin.request.dao.CoreRequestUrlDao;
import net.sinodawn.module.admin.request.service.CoreRequestUrlService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreRequestUrlServiceImpl implements CoreRequestUrlService {
   @Autowired
   private CoreRequestUrlDao coreRequestUrlDao;

   public CoreRequestUrlDao getDao() {
      return this.coreRequestUrlDao;
   }

   @Transactional
   @AuditTrailEntry(AuditTrailType.INSERT)
   public Long insert(RestJsonWrapperBean jsonWrapper) {
      CoreRequestUrlBean coreRequestUrl = (CoreRequestUrlBean)jsonWrapper.parseUnique(CoreRequestUrlBean.class);
      coreRequestUrl.setId(ApplicationContextHelper.getNextIdentity());
      this.getDao().insert(coreRequestUrl);
      return coreRequestUrl.getId();
   }

   @Cacheable(
      value = {"T_CORE_REQUEST_URL"},
      key = "'GROUPING_BY_URL_MAP'"
   )
   public Map<String, List<CoreRequestUrlBean>> getGroupingByUrlMap() {
      return (Map)this.getDao().selectAll().stream().collect(Collectors.groupingBy((u) -> {
         return StringUtils.startsWith(u.getUrl(), "/") ? u.getUrl() : "/" + u.getUrl();
      }));
   }
}
