/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.admin.request.resource.impl;

import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.admin.request.resource.CoreRequestUrlResource;
import net.sinodawn.module.admin.request.service.CoreRequestUrlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@LogModule("路径配置")
@RestController
public class CoreRequestUrlResourceImpl implements CoreRequestUrlResource {
   @Autowired
   private CoreRequestUrlService coreRequestUrlService;

   public CoreRequestUrlService getService() {
      return this.coreRequestUrlService;
   }

   @Log(
      value = "新增路径配置",
      type = LogType.INSERT
   )
   @RequestMapping(
      method = {RequestMethod.POST}
   )
   public Long insert(RestJsonWrapperBean wrapper) {
      return (Long)this.getService().insert(wrapper);
   }
}
