/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.admin.request.bean;

import com.alibaba.fastjson.annotation.JSONField;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;
import org.springframework.data.annotation.Id;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Table("T_CORE_REQUEST_URL")
public class CoreRequestUrlBean extends AbstractInsertable<Long> implements Insertable<Long> {
   private static final long serialVersionUID = -82566196618711043L;
   @Id
   private Long id;
   private String menuId;
   private String note;
   private String url;
   private String method;
   private String createdById;
   private String createdByName;
   @JSONField(
      format = "yyyy-MM-dd"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime createdTime;
   private String createdByOrgId;
   private String createdByOrgName;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public String getMenuId() {
      return this.menuId;
   }

   public void setMenuId(String menuId) {
      this.menuId = menuId;
   }

   public String getUrl() {
      return this.url;
   }

   public void setUrl(String url) {
      this.url = url;
   }

   public String getMethod() {
      return this.method;
   }

   public void setMethod(String method) {
      this.method = method;
   }

   public String getCreatedById() {
      return this.createdById;
   }

   public void setCreatedById(String createdById) {
      this.createdById = createdById;
   }

   public String getCreatedByName() {
      return this.createdByName;
   }

   public void setCreatedByName(String createdByName) {
      this.createdByName = createdByName;
   }

   public LocalDateTime getCreatedTime() {
      return this.createdTime;
   }

   public void setCreatedTime(LocalDateTime createdTime) {
      this.createdTime = createdTime;
   }

   public String getCreatedByOrgId() {
      return this.createdByOrgId;
   }

   public void setCreatedByOrgId(String createdByOrgId) {
      this.createdByOrgId = createdByOrgId;
   }

   public String getCreatedByOrgName() {
      return this.createdByOrgName;
   }

   public void setCreatedByOrgName(String createdByOrgName) {
      this.createdByOrgName = createdByOrgName;
   }

   public String getNote() {
      return this.note;
   }

   public void setNote(String note) {
      this.note = note;
   }
}
