/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.validator.permission.aspect;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.validator.permission.PermissionValidator;
import net.sinodawn.framework.validator.permission.annotation.ValidatePermissionWith;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

import java.util.Iterator;
import java.util.List;

@Aspect
@Component
@Order(100)
public class PermissionValidatorAspect {
   private ExpressionParser parser = new SpelExpressionParser();

   @Around("@annotation(validatePermissionWith)")
   public Object doValidate(ProceedingJoinPoint pjp, ValidatePermissionWith validatePermissionWith) throws Throwable {
      Object[] args = pjp.getArgs();
      PermissionValidator validator = (PermissionValidator)ApplicationContextHelper.getBean(validatePermissionWith.value());
      String table = null;
      if (!StringUtils.contains(validatePermissionWith.table(), ".") && !StringUtils.contains(validatePermissionWith.table(), "#")) {
         table = validatePermissionWith.table();
      } else {
         StandardEvaluationContext context = new StandardEvaluationContext(pjp.getTarget());
         table = (String)this.parser.parseExpression(validatePermissionWith.table()).getValue(context);
      }

      String category = validatePermissionWith.category();
      Object arg = args[validatePermissionWith.pos()];
      if (arg != null) {
         if (RestJsonWrapperBean.class.equals(arg.getClass())) {
            List<String> idList = ((RestJsonWrapperBean)arg).parseId(String.class);
            Iterator var9 = idList.iterator();

            while(var9.hasNext()) {
               String id = (String)var9.next();
               if (!validator.isValid(table, category, id)) {
                  return null;
               }
            }
         } else if (!validator.isValid(table, category, arg)) {
            return null;
         }
      }

      return pjp.proceed();
   }
}
