/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.validator.permission.aspect;

import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.admin.request.bean.CoreRequestUrlBean;
import net.sinodawn.module.admin.request.service.CoreRequestUrlService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Aspect
@Component
@Order(100)
@ConditionalOnProperty(
   name = {"sino.api.check-access-permission"},
   havingValue = "true"
)
public class CheckAccessPermittedAspect {
   @Autowired
   private CoreRequestUrlService requestUrlService;
//   @Autowired
//   private CoreMenuService menuService;

   @Around("within(net.sinodawn..resource..*)")
   public Object check(ProceedingJoinPoint pjp) throws Throwable {
      return pjp.proceed();
   }

   private List<CoreRequestUrlBean> getRequestUrlList(Map<String, List<CoreRequestUrlBean>> map, String requestUri, String method) {
      return (List<CoreRequestUrlBean>) map.entrySet().stream()
              .filter((e) -> this.match(e.getKey(), requestUri))
              .map((e) -> (List)e.getValue())
              .flatMap(Collection::stream)
              .filter((e) -> StringUtils.isBlank(((CoreRequestUrlBean)e).getMethod()) || ((CoreRequestUrlBean)e).getMethod().equals(method))
              .collect(Collectors.toList());
   }

   private boolean match(String rawUri, String requestUri) {
      char[] rawUriChars = rawUri.toCharArray();
      char[] requestUriChars = requestUri.toCharArray();
      int i = 0;
      int j = 0;
      int ik = rawUriChars.length;

      int jk;
      for(jk = requestUriChars.length; i < ik && j < jk; ++j) {
         char rawUriChar = rawUriChars[i];
         char requestUriChar = requestUriChars[j];
         if (rawUriChar == '{') {
            while(rawUriChar != '}') {
               ++i;
               rawUriChar = rawUriChars[i];
            }

            while(requestUriChar != '/' && j < jk - 1) {
               ++j;
               requestUriChar = requestUriChars[j];
            }

            if (i == ik - 1) {
               return j == jk - 1;
            }

            if (j == jk - 1) {
               return false;
            }

            ++i;
            rawUriChar = rawUriChars[i];
         }

         if (rawUriChar != requestUriChar) {
            return false;
         }

         ++i;
      }

      return i == ik && j == jk;
   }
}
