/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.validator.permission;

import net.sinodawn.framework.exception.core.HttpErrorMessage;
import net.sinodawn.framework.utils.ServletUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

public interface PermissionValidator {
   Logger logger = LogManager.getLogger(PermissionValidator.class);

   default boolean isValid(String table, String category, Object id) {
      boolean var11 = false;

      boolean var4;
      try {
         var11 = true;
         var4 = this.doValid(table, category, id);
         var11 = false;
      } finally {
         if (var11) {
            HttpServletRequest var8 = ServletUtils.getCurrentRequest();
            String constraintViolation = (String)var8.getAttribute("validator.unauthorized");
            if (constraintViolation != null) {
               ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.BAD_REQUEST, constraintViolation));
            }

         }
      }

      HttpServletRequest request = ServletUtils.getCurrentRequest();
      String constraintViolation = (String)request.getAttribute("validator.unauthorized");
      if (constraintViolation != null) {
         ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.BAD_REQUEST, constraintViolation));
      }

      return var4;
   }

   boolean doValid(String table, String category, Object id);

   default void addConstraintViolation(String message) {
      HttpServletRequest request = ServletUtils.getCurrentRequest();
      String constraintViolation = (String)request.getAttribute("validator.unauthorized");
      if (constraintViolation == null) {
         constraintViolation = "";
      } else {
         constraintViolation = constraintViolation + "; ";
      }

      constraintViolation = constraintViolation + message;
      request.setAttribute("validator.unauthorized", constraintViolation);
   }
}
