/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.validator.data;

import com.alibaba.fastjson.JSON;
import net.sinodawn.framework.exception.core.HttpErrorMessage;
import net.sinodawn.framework.utils.ServletUtils;
import org.springframework.http.HttpStatus;

import javax.servlet.http.HttpServletRequest;
import java.util.function.Predicate;

//import net.sinodawn.framework.i18n.I18nHelper;

public interface DataValidator {
   default boolean isValid(Object... args) {
      boolean var9 = false;

      boolean var2;
      try {
         var9 = true;
         var2 = this.doValid(args);
         var9 = false;
      } finally {
         if (var9) {
            HttpServletRequest var6 = ServletUtils.getCurrentRequest();
            String constraintViolation = (String)var6.getAttribute("validator.constraintViolation");
            if (constraintViolation != null) {
               ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.BAD_REQUEST, constraintViolation));
            }

         }
      }

      HttpServletRequest request = ServletUtils.getCurrentRequest();
      String constraintViolation = (String)request.getAttribute("validator.constraintViolation");
      if (constraintViolation != null) {
         ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.BAD_REQUEST, constraintViolation));
      }

      return var2;
   }

   boolean doValid(Object... args);

   default void addConstraintViolation(String message) {
      HttpServletRequest request = ServletUtils.getCurrentRequest();
      String constraintViolation = (String)request.getAttribute("validator.constraintViolation");
      if (constraintViolation == null) {
         constraintViolation = "";
      }

      constraintViolation = constraintViolation + message;
      request.setAttribute("validator.constraintViolation", constraintViolation);
   }

   default <T> boolean test(String businessName, String table, String column, T item, Predicate<T> predicate, String message) {
      if (!predicate.test(item)) {
//         this.addConstraintViolation(businessName + "：[" + I18nHelper.getMessage(table.toUpperCase() + "." + column.toUpperCase()) + "] " + I18nHelper.getMessage(message));
         return false;
      } else {
         return true;
      }
   }

   default boolean testNoneNull(String businessName, String table, String column, Object value) {
      if (value == null) {
//         this.addConstraintViolation(businessName + "：[" + I18nHelper.getMessage(table.toUpperCase() + "." + column.toUpperCase()) + "] " + I18nHelper.getMessage("SINO.EXCEPTION.REQUIRE_NOT_EMPTY"));
         return false;
      } else {
         return true;
      }
   }

   default boolean testJson(String businessName, String table, String column, String value) {
      try {
         JSON.parseObject(value);
         return true;
      } catch (Exception var6) {
//         this.addConstraintViolation(businessName + "：[" + I18nHelper.getMessage(table.toUpperCase() + "." + column.toUpperCase()) + "] " + I18nHelper.getMessage("SINO.EXCEPTION.REQUIRE_JSON"));
         return false;
      }
   }
}
