/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.utils;

import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.exception.UnexpectedException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.*;

public abstract class XmlUtils {
   public static final Document read(File xmlFile) {
      try {
         InputStream is = new FileInputStream(xmlFile);
         Throwable var2 = null;

         Document var3;
         try {
            var3 = read((InputStream)is);
         } catch (Throwable var13) {
            var2 = var13;
            throw var13;
         } finally {
            if (is != null) {
               if (var2 != null) {
                  try {
                     is.close();
                  } catch (Throwable var12) {
                     var2.addSuppressed(var12);
                  }
               } else {
                  is.close();
               }
            }

         }

         return var3;
      } catch (IOException var15) {
         throw new FileException(var15);
      }
   }

   public static final Document read(String xml) {
      if (StringUtils.isEmpty(xml)) {
         return null;
      } else {
         try {
            InputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Throwable var2 = null;

            Document var3;
            try {
               var3 = read((InputStream)is);
            } catch (Throwable var13) {
               var2 = var13;
               throw var13;
            } finally {
               if (is != null) {
                  if (var2 != null) {
                     try {
                        is.close();
                     } catch (Throwable var12) {
                        var2.addSuppressed(var12);
                     }
                  } else {
                     is.close();
                  }
               }

            }

            return var3;
         } catch (IOException var15) {
            throw new UnexpectedException(var15);
         }
      }
   }

   public static final Document read(InputStream xmlInputStream) {
      SAXReader saxReader = new SAXReader();

      try {
         return saxReader.read(xmlInputStream);
      } catch (DocumentException var3) {
         throw new UnexpectedException(var3);
      }
   }

   public static final String getAttributeValue(Element element, String attributeName) {
      Attribute attribute = element.attribute(attributeName);
      return attribute == null ? null : attribute.getValue();
   }
}
