/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.utils;

import net.sinodawn.framework.exception.FileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public abstract class WkHtmlToPdfUtils {
   public static final void createPdf(Path pdfPath, String htmlContent) {
      try {
         Path path = Files.createTempFile("", ".html");
         BufferedWriter writer = Files.newBufferedWriter(path);
         Throwable var4 = null;

         try {
            writer.write(htmlContent);
            writer.flush();
         } catch (Throwable var14) {
            var4 = var14;
            throw var14;
         } finally {
            if (writer != null) {
               if (var4 != null) {
                  try {
                     writer.close();
                  } catch (Throwable var13) {
                     var4.addSuppressed(var13);
                  }
               } else {
                  writer.close();
               }
            }

         }

         FileUtils.makeDirs(pdfPath);
         StringBuilder sb = new StringBuilder();
         if (SystemUtils.isWindows()) {
            sb.append("wkhtmltopdf.exe");
         } else {
            sb.append("./wkhtmltopdf");
         }

         sb.append(" ").append(path.toString()).append(" ").append(pdfPath.toString());
         SystemUtils.exec(sb.toString());
      } catch (IOException var16) {
         throw new FileException(var16);
      }
   }
}
