/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.utils;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public abstract class ScriptUtils {
   private static final ScriptEngineManager manager = new ScriptEngineManager();
   private static final ScriptEngine javaScriptEngine;

   public static <T> T evalJavaScript(String javaScript) {
      try {
         return (T) javaScriptEngine.eval(javaScript);
      } catch (ScriptException var2) {
         throw new net.sinodawn.framework.exception.ScriptException(var2);
      }
   }

   static {
      javaScriptEngine = manager.getEngineByName("JavaScript");
   }
}
