/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.utils;

import net.sinodawn.framework.exception.database.JdbcException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.sql.*;
import java.util.HashMap;
import java.util.Map;

public abstract class JdbcUtils {
    private static final Logger logger = LogManager.getLogger(JdbcUtils.class);

    public JdbcUtils() {
    }

    public static Map<String, Object> mapRow(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            Map<String, Object> map = new HashMap<>();

            for(int i = 0; i < count; ++i) {
                String name = rsmd.getColumnName(i + 1);
                map.put(name, rs.getObject(name));
            }

            return map;
        } catch (SQLException var6) {
            throw new JdbcException(var6);
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            } catch (Throwable var2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected exception on closing JDBC ResultSet", var2);
                }
            }
        }

    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            } catch (Throwable var2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected exception on closing JDBC Statement", var2);
                }
            }
        }

    }

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            } catch (Throwable var2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected exception on closing JDBC Connection", var2);
                }
            }
        }

    }
}
