/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.utils;

import net.sinodawn.framework.exception.UnexpectedException;

import java.util.*;
import java.util.stream.Collectors;


public abstract class CollectionUtils {
    public CollectionUtils() {
    }

    public static <T> boolean isEmpty(Collection<T> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static final <T> List<T> union(Collection<T> first, Collection<T> second) {
        List<T> unionList = new ArrayList(first);
        unionList.addAll(second);
        return (List)unionList.stream().distinct().collect(Collectors.toList());
    }

    public static final <T> List<T> intersection(Collection<T> first, Collection<T> second) {
        return (List)first.stream().filter((f) -> {
            return second.contains(f);
        }).distinct().collect(Collectors.toList());
    }

    public static final <T> List<T> disjunction(Collection<T> first, Collection<T> second) {
        List<T> disjunctionList = subtract(first, second);
        disjunctionList.addAll(subtract(second, first));
        return disjunctionList;
    }

    public static final <T> List<T> subtract(Collection<T> first, Collection<T> second) {
        return (List)first.stream().filter((f) -> {
            return !second.contains(f);
        }).distinct().collect(Collectors.toList());
    }

    public static final boolean containsIgnoreCase(Collection<String> collection, String value) {
        if (collection.isEmpty()) {
            return false;
        } else {
            Iterator var2 = collection.iterator();

            while(var2.hasNext()) {
                String v = (String)var2.next();
                if (v == null) {
                    if (value == null) {
                        return true;
                    }
                } else if (v.equalsIgnoreCase(value)) {
                    return true;
                }
            }

            return false;
        }
    }

    public static final Object getFirstValue(Map<?, ?> map) {
        return map != null && !map.isEmpty() ? map.values().toArray()[0] : null;
    }

    public static final Object getFirstValue(Collection<?> collection) {
        return collection != null && !collection.isEmpty() ? collection.iterator().next() : null;
    }

    public static final boolean containsKeyIgnorecase(Map<String, ?> map, String key) {
        return map != null && !map.isEmpty() ? map.keySet().stream().anyMatch((k) -> {
            return k.equalsIgnoreCase(key);
        }) : false;
    }

    public static final Object getValueIgnorecase(Map<String, ?> map, String key) {
        if (map != null && !map.isEmpty()) {
            String actualKey = (String)map.keySet().stream().filter((k) -> {
                return k.equalsIgnoreCase(key);
            }).findFirst().orElse(null);
            return StringUtils.isEmpty(actualKey) ? null : map.get(actualKey);
        } else {
            return null;
        }
    }

    public static <S, T> List<T> convert(List<S> itemList, Class<T> type) {
        if (itemList.isEmpty()) {
            return emptyList();
        } else {
            Class<S> sourceType = (Class<S>) itemList.get(0).getClass();
            return type.isAssignableFrom(sourceType) ? (List) itemList.stream().collect(Collectors.toList()) : (List)itemList.stream().map((s) -> ConvertUtils.convert(s, type)).collect(Collectors.toList());
        }
    }

    public static <T> List<T> distinct(List<T> itemList) {
        return itemList.stream().distinct().collect(Collectors.toList());
    }

    public static void lowerCaseKey(Map<String, Object> map) {
        new HashSet<>(map.keySet()).forEach((k) -> {
            String lowerCaseKey = k.toLowerCase();
            if (!k.equals(lowerCaseKey)) {
                Object value = map.get(k);
                map.remove(k);
                map.put(lowerCaseKey, value);
            }

        });
    }

    public static void upperCaseKey(Map<String, Object> map) {
        (new HashSet<>(map.keySet())).forEach((k) -> {
            String upperCaseKey = k.toUpperCase();
            if (!k.equals(upperCaseKey)) {
                Object value = map.get(k);
                map.remove(k);
                map.put(upperCaseKey, value);
            }

        });
    }

    public static final <K, V> void putIfNotBlank(Map<K, V> map, K key, V value) {
        if (value != null && !StringUtils.isBlank(value.toString())) {
            map.put(key, value);
        }

    }

    public static final <T> void sort(List<T> list, Comparator<T> comparator) {
        int size = list.size();
        if (size > 1) {
            ArrayList sortedList = new ArrayList();

            boolean minFound;
            do {
                if (sortedList.size() >= size) {
                    list.addAll(sortedList);
                    return;
                }

                int innerSize = list.size();
                minFound = true;

                for(int i = 0; i < innerSize; ++i) {
                    T item = list.get(i);
                    minFound = true;

                    for(int j = 0; j < innerSize; ++j) {
                        if (i != j) {
                            T another = list.get(j);
                            if (comparator.compare(item, another) > 0) {
                                minFound = false;
                                break;
                            }
                        }
                    }

                    if (minFound) {
                        sortedList.add(item);
                        list.remove(i);
                        break;
                    }
                }
            } while(minFound);

            throw new UnexpectedException("SINO.EXCEPTION.ORDER_INFINITE_LOOP");
        }
    }

    public static final <T> List<T> emptyList() {
        return new ArrayList();
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return new HashMap();
    }
}

