/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.tree.resource;

import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.support.tree.bean.AbstractTreeNode;
import net.sinodawn.framework.support.tree.service.GenericTreeService;
import java.io.Serializable;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface GenericTreeResource<S extends GenericTreeService<T, ID>, T extends Persistable<ID>, ID extends Serializable> {
   S getService();

   @Log(
      value = "查询树",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/tree/{parentId}"},
      method = {RequestMethod.POST}
   )
   default List<? extends AbstractTreeNode> selectTree(@PathVariable String parentId, RestJsonWrapperBean jsonWrapper) {
      MapperParameter parameter = jsonWrapper.extractMapFilter();
      parameter.put("parentId", parentId);
      return this.getService().selectTree(parameter);
   }

   @Log(
      value = "弹出页面查询树",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/pop-tree/{parentId}"},
      method = {RequestMethod.POST}
   )
   default List<? extends AbstractTreeNode> selectPopTree(@PathVariable String parentId, RestJsonWrapperBean jsonWrapper) {
      MapperParameter parameter = jsonWrapper.extractMapFilter();
      parameter.put("parentId", parentId);
      parameter.setSuspendedFlag("0");
      return this.getService().selectTree(parameter);
   }
}
