/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.tree.resource;

import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.support.tree.bean.AbstractTreeNode;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface GenericTreeCloudResource<T extends Persistable<ID>, ID extends Serializable> {
   @RequestMapping(
      value = {"/tree/{parentId}"},
      method = {RequestMethod.POST}
   )
   ArrayList<? extends AbstractTreeNode> selectTree(@PathVariable String parentId, RestJsonWrapperBean jsonWrapper);

   @RequestMapping(
      value = {"/pop-tree/{parentId}"},
      method = {RequestMethod.POST}
   )
   ArrayList<? extends AbstractTreeNode> selectPopTree(@PathVariable String parentId, RestJsonWrapperBean jsonWrapper);
}
