/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.tree.resource;

import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.support.tree.bean.AbstractTreeNode;
import net.sinodawn.framework.support.tree.service.GenericTreeService;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.PathVariable;

public interface AbstractGenericTreeResource<S extends GenericTreeService<T, ID>, T extends Persistable<ID>, ID extends Serializable> extends GenericTreeCloudResource<T, ID> {
   S getService();

   @Log(
      value = "查询树",
      type = LogType.SELECT
   )
   default ArrayList<? extends AbstractTreeNode> selectTree(@PathVariable String parentId, RestJsonWrapperBean jsonWrapper) {
      MapperParameter parameter = jsonWrapper.extractMapFilter();
      parameter.put("parentId", parentId);
      return (ArrayList)this.getService().selectTree(parameter);
   }

   @Log(
      value = "弹出页面查询树",
      type = LogType.SELECT
   )
   default ArrayList<? extends AbstractTreeNode> selectPopTree(@PathVariable String parentId, RestJsonWrapperBean jsonWrapper) {
      MapperParameter parameter = jsonWrapper.extractMapFilter();
      parameter.put("parentId", parentId);
      parameter.setSuspendedFlag("0");
      return (ArrayList)this.getService().selectTree(parameter);
   }
}
