/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.tree;

import net.sinodawn.framework.support.tree.bean.AbstractTreeNode;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public abstract class TreeHelper {
   public static <T, R extends AbstractTreeNode> List<R> parseTreeNode(List<T> treeItemList, TreeDescriptor<T> descriptor, Class<R> treeNodeClass) {
      if (treeItemList.isEmpty()) {
         return CollectionUtils.emptyList();
      } else {
         List<T> cloneTreeItemList = new ArrayList();
         cloneTreeItemList.addAll(treeItemList);
         cloneTreeItemList.sort((b1, b2) -> {
            return descriptor.getOrderComparator().compare(b1, b2);
         });
         List<R> sortedNodeList = cloneTreeItemList.stream().map((t) -> {
            R node;
            if (descriptor.getParseTreeNodeFunction() != null) {
               node = (R) descriptor.getParseTreeNodeFunction().apply(t);
            } else {
               node = ClassUtils.newInstance(treeNodeClass);
               BeanUtils.copyProperties((Object)t, node);
            }

            String id = (String)descriptor.getParseTreeNodeIdFunc().apply(t);
            node.setId(id);
            if (descriptor.getParseTreeNodeParentIdFunc() != null) {
               node.setParentId((String)descriptor.getParseTreeNodeParentIdFunc().apply(t));
            }

            node.setText((String)descriptor.getParseTreeNodeTextFunction().apply(t));
            Iterator var5 = descriptor.getConsumerList().iterator();

            while(var5.hasNext()) {
               BiConsumer<T, AbstractTreeNode> consumer = (BiConsumer)var5.next();
               consumer.accept(t, node);
            }

            return node;
         }).collect(Collectors.toList());
         List<R> sortedRootNodeList = new ArrayList();
         Iterator var6;
         AbstractTreeNode node;
         if (descriptor.getParseTreeNodeParentIdFunc() != null) {
            CollectionUtils.sort(sortedNodeList, new Comparator<R>() {
               public int compare(R r1, R r2) {
                  if (r1.getId().equals(r2.getParentId())) {
                     return -1;
                  } else {
                     return r2.getId().equals(r1.getParentId()) ? 1 : 0;
                  }
               }
            });
            var6 = sortedNodeList.iterator();

            while(var6.hasNext()) {
               node = (AbstractTreeNode)var6.next();
               boolean hasParent = false;

               for (R r : sortedNodeList) {
                  R innerLoopNode = (R) r;
                  if (innerLoopNode.getId().equals(node.getParentId())) {
                     if (innerLoopNode.getLvl() == null) {
                        innerLoopNode.setLvl(1);
                     }

                     innerLoopNode.addChild(node);
                     node.setLvl(innerLoopNode.getLvl() + 1);
                     hasParent = true;
                     break;
                  }
               }

               if (!hasParent) {
                  if (node.getLvl() == null) {
                     node.setLvl(1);
                  }

                  sortedRootNodeList.add((R) node);
               }
            }
         } else {
            var6 = sortedNodeList.iterator();

            label75:
            while(var6.hasNext()) {
               node = (AbstractTreeNode)var6.next();
               int nodeLength = node.getId().length();
               R parentNode = null;
               Iterator var15 = sortedNodeList.iterator();

               while(true) {
                  AbstractTreeNode innerLoopNode;
                  int innerLoopNodeLength;
                  do {
                     do {
                        do {
                           if (!var15.hasNext()) {
                              if (parentNode == null) {
                                 if (node.getLvl() == null) {
                                    node.setLvl(1);
                                 }

                                 sortedRootNodeList.add((R) node);
                              } else {
                                 if (parentNode.getLvl() == null) {
                                    parentNode.setLvl(1);
                                 }

                                 parentNode.addChild(node);
                                 node.setLvl(parentNode.getLvl() + 1);
                                 node.setParentId(parentNode.getId());
                              }
                              continue label75;
                           }

                           innerLoopNode = (AbstractTreeNode)var15.next();
                           innerLoopNodeLength = innerLoopNode.getId().length();
                        } while(nodeLength <= innerLoopNodeLength);
                     } while(!StringUtils.startsWith(node.getId(), innerLoopNode.getId()));
                  } while(parentNode != null && innerLoopNodeLength <= parentNode.getId().length());

                  parentNode = (R) innerLoopNode;
               }
            }
         }

         return sortedRootNodeList;
      }
   }

   public static <R extends AbstractTreeNode> void updateChildQty(List<R> treeItemList) {
      Iterator var1 = treeItemList.iterator();

      while(true) {
         while(var1.hasNext()) {
            R item = (R) var1.next();
            if (item.getChildren() != null && !item.getChildren().isEmpty()) {
               item.setChildQty(item.getChildren().size());
               updateChildQty(item.getChildren());
            } else {
               item.setChildQty(0);
            }
         }

         return;
      }
   }
}
