/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.tree;

import net.sinodawn.framework.support.tree.bean.AbstractTreeNode;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class TreeDescriptor<T> {
   private Function<T, String> parseTreeNodeIdFunc;
   private Function<T, String> parseTreeNodeParentIdFunc;
   private Function<T, String> parseTreeNodeTextFunction;
   private Comparator<T> orderComparator;
   private Function<T, ? extends AbstractTreeNode> parseTreeNodeFunction;
   private List<BiConsumer<T, AbstractTreeNode>> consumerList;

   public TreeDescriptor(String idName) {
      this(idName, idName);
   }

   public TreeDescriptor(String idName, String textName) {
      this.consumerList = new ArrayList();
      this.parseTreeNodeIdFunc = (t) -> {
         return (String)ConvertUtils.convert(ReflectionUtils.invokeReadMethod(t, idName), String.class);
      };
      this.orderComparator = (v1, v2) -> {
         return ((Comparable)ReflectionUtils.invokeReadMethod(v1, idName)).compareTo((Comparable)ReflectionUtils.invokeReadMethod(v2, idName));
      };
      this.parseTreeNodeTextFunction = (t) -> {
         return (String)ConvertUtils.convert(ReflectionUtils.invokeReadMethod(t, textName), String.class);
      };
   }

   public TreeDescriptor(String idName, String parentIdName, String textName) {
      this(idName, parentIdName, textName, idName);
   }

   public TreeDescriptor(String idName, String parentIdName, String textName, String orderName) {
      this.consumerList = new ArrayList();
      this.parseTreeNodeIdFunc = (t) -> {
         return (String)ConvertUtils.convert(ReflectionUtils.invokeReadMethod(t, idName), String.class);
      };
      this.parseTreeNodeParentIdFunc = (t) -> {
         return (String)ConvertUtils.convert(ReflectionUtils.invokeReadMethod(t, parentIdName), String.class);
      };
      this.orderComparator = (v1, v2) -> {
         return ((Comparable)ReflectionUtils.invokeReadMethod(v1, orderName)).compareTo((Comparable)ReflectionUtils.invokeReadMethod(v2, orderName));
      };
      this.parseTreeNodeTextFunction = (t) -> {
         return (String)ConvertUtils.convert(ReflectionUtils.invokeReadMethod(t, textName), String.class);
      };
   }

   public Function<T, String> getParseTreeNodeIdFunc() {
      return this.parseTreeNodeIdFunc;
   }

   public Function<T, String> getParseTreeNodeParentIdFunc() {
      return this.parseTreeNodeParentIdFunc;
   }

   public void setParseTreeNodeParentIdFunc(Function<T, String> parseTreeNodeParentIdFunc) {
      this.parseTreeNodeParentIdFunc = parseTreeNodeParentIdFunc;
   }

   public Function<T, String> getParseTreeNodeTextFunction() {
      return this.parseTreeNodeTextFunction;
   }

   public void setParseTreeNodeTextFunction(Function<T, String> parseTreeNodeTextFunction) {
      this.parseTreeNodeTextFunction = parseTreeNodeTextFunction;
   }

   public Comparator<T> getOrderComparator() {
      return this.orderComparator;
   }

   public void setOrderComparator(Comparator<T> orderComparator) {
      this.orderComparator = orderComparator;
   }

   public List<BiConsumer<T, AbstractTreeNode>> getConsumerList() {
      return this.consumerList;
   }

   public void addConsumer(BiConsumer<T, AbstractTreeNode> consumer) {
      this.consumerList.add(consumer);
   }

   public Function<T, ? extends AbstractTreeNode> getParseTreeNodeFunction() {
      return this.parseTreeNodeFunction;
   }

   public void setParseTreeNodeFunction(Function<T, ? extends AbstractTreeNode> parseTreeNodeFunction) {
      this.parseTreeNodeFunction = parseTreeNodeFunction;
   }
}
