/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.tree;

import net.sinodawn.framework.support.tree.bean.AbstractTreeNode;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class GroupingTreeHelper {
   public static <T, R extends AbstractTreeNode> List<R> parseTreeNode(List<T> treeItemList, GroupingTreeDescriptor<T> descriptor, Class<R> treeNodeClass) {
      if (treeItemList.isEmpty()) {
         return CollectionUtils.emptyList();
      } else {
         Map<String, R> map = new HashMap();

         for (T item : treeItemList) {
            String parentId = null;
            int lvl = 1;

            for (Iterator var8 = descriptor.getNodeMakerList().iterator(); var8.hasNext(); ++lvl) {
               GroupingTreeDescriptor.NodeMaker<T> nodeMaker = (GroupingTreeDescriptor.NodeMaker) var8.next();
               String id = nodeMaker.getId(item);
               String key = id + "$" + lvl;
               if (!map.containsKey(key)) {
                  R node = ClassUtils.newInstance(treeNodeClass);
                  node.setId(id);
                  node.setText(nodeMaker.getText(item));
                  node.setParentId(parentId);
                  node.setLvl(lvl);
                  nodeMaker.copy(item, node);
                  map.put(key, node);
               }

               parentId = id;
            }
         }

         List<R> treeNodeList = new ArrayList(map.values());

         for (R r : treeNodeList) {
            R treeNode = (R) r;
            if (!StringUtils.isEmpty(treeNode.getParentId())) {
               R parentTreeNode = (R) treeNodeList.stream().filter((n) -> {
                  return Objects.toString(n.getId(), "").equals(Objects.toString(treeNode.getParentId(), ""));
               }).findFirst().get();
               parentTreeNode.addChild(treeNode);
            }
         }

         treeNodeList.removeIf((t) -> {
            return !StringUtils.isEmpty(t.getParentId());
         });
         sortTreeNodeList(treeNodeList, descriptor);
         return treeNodeList;
      }
   }

   public static <R extends AbstractTreeNode> void updateChildQty(List<R> treeItemList) {
      Iterator var1 = treeItemList.iterator();

      while(true) {
         while(var1.hasNext()) {
            R item = (R) var1.next();
            if (item.getChildren() != null && !item.getChildren().isEmpty()) {
               item.setChildQty(item.getChildren().size());
               updateChildQty(item.getChildren());
            } else {
               item.setChildQty(0);
            }
         }

         return;
      }
   }

   private static <T, R extends AbstractTreeNode> void sortTreeNodeList(List<R> treeNodeList, GroupingTreeDescriptor<T> descriptor) {
      if (treeNodeList != null && !treeNodeList.isEmpty()) {
         int lvl = treeNodeList.get(0).getLvl();
         GroupingTreeDescriptor.NodeMaker<T> nodeMarker = (GroupingTreeDescriptor.NodeMaker)descriptor.getNodeMakerList().get(lvl - 1);
         treeNodeList.sort(nodeMarker.getNodeComparator());

         for (R r : treeNodeList) {
            R treeNode = r;
            sortTreeNodeList(treeNode.getChildren(), descriptor);
         }

      }
   }
}
