/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.tree;

import net.sinodawn.framework.support.tree.bean.AbstractTreeNode;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class GroupingTreeDescriptor<T> {
   private List<NodeMaker<T>> nodeMakerList;

   public GroupingTreeDescriptor(List<NodeMaker<T>> nodeMakerList) {
      this.nodeMakerList = nodeMakerList;
   }

   public List<NodeMaker<T>> getNodeMakerList() {
      return this.nodeMakerList;
   }

   public interface NodeMaker<T> {
      String getId(T item);

      String getText(T item);

      default void copy(T item, AbstractTreeNode node) {
      }

      default <R extends AbstractTreeNode> Comparator<R> getNodeComparator() {
         return (r1, r2) -> {
            return Objects.toString(r1.getId(), "").compareTo(Objects.toString(r2.getId(), ""));
         };
      }
   }
}
