/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.table;

import net.sinodawn.framework.support.domain.AbstractBaseData;
import net.sinodawn.framework.support.table.bean.TableCellBean;
import net.sinodawn.framework.support.table.bean.TableRowBean;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class TableHelper {
   public static final <T extends AbstractBaseData> List<TableRowBean> parseTableRowList(List<T> tableCellList, TableCellDescriptor<T> descriptor) {
      if (tableCellList.isEmpty()) {
         return CollectionUtils.emptyList();
      } else {
         List<String> pivotList = descriptor.getPivotList();
         List<String> extList = descriptor.getExtList();
         if (pivotList.isEmpty()) {
            return CollectionUtils.emptyList();
         } else {
            List<TableRowBean> rowList = new ArrayList();

            for (T c : tableCellList) {
               TableCellBean cell = new TableCellBean();
               cell.setKey((String) descriptor.getParseCellKeyFunc().apply(c));
               cell.setValue((String) descriptor.getParseCellValueFunc().apply(c));
               cell.setExt$Item("$field", descriptor.getCellFieldName());
               cell.setExt$Item("id", (String) descriptor.getParseIdFunc().apply(c));
               Iterator var8 = extList.iterator();

               while (var8.hasNext()) {
                  String ext = (String) var8.next();
                  String extValue = (String) ConvertUtils.convert(BeanUtils.getPropertyValue(c, ext), String.class);
                  cell.setExt$Item(ext, extValue);
               }

               StringBuilder pivotText = new StringBuilder();
               Map<String, Object> pivotValueMap = new HashMap();
               Iterator var13 = pivotList.iterator();

               while (var13.hasNext()) {
                  String p = (String) var13.next();
                  String pValue = (String) ConvertUtils.convert(BeanUtils.getPropertyValue(c, p), String.class);
                  pivotText.append(p).append(":").append(pValue).append(";");
                  pivotValueMap.put("pivot_" + p, pValue);
               }

               TableRowBean row = (TableRowBean) rowList.stream().filter((r) -> {
                  return r.getPivotText().equals(pivotText.toString());
               }).findFirst().orElse(null);
               if (null == row) {
                  TableRowBean nextRow = new TableRowBean();
                  nextRow.setPivotText(pivotText.toString());
                  nextRow.put(cell.getKey(), cell.getValue());
                  nextRow.setExt$Item(cell.getKey() + "_" + "ext$", cell.getExt$());
                  nextRow.setExt$(pivotValueMap);
                  rowList.add(nextRow);
               } else {
                  row.put(cell.getKey(), cell.getValue());
                  row.setExt$Item(cell.getKey() + "_" + "ext$", cell.getExt$());
                  row.setExt$(pivotValueMap);
               }
            }

            return rowList;
         }
      }
   }
}
