/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.table;

import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class TableCellDescriptor<T> {
   private Function<T, String> parseCellKeyFunc;
   private Function<T, String> parseCellValueFunc;
   private Function<T, String> parseIdFunc;
   private String cellFieldName;
   private List<String> pivotList = new ArrayList();
   private List<String> extList = new ArrayList();

   public TableCellDescriptor(String key, String value) {
      this.parseCellKeyFunc = (t) -> {
         return (String)ConvertUtils.convert(ReflectionUtils.invokeReadMethod(t, key), String.class);
      };
      this.parseCellValueFunc = (t) -> {
         return (String)ConvertUtils.convert(ReflectionUtils.invokeReadMethod(t, value), String.class);
      };
      this.parseIdFunc = (t) -> {
         return (String)ConvertUtils.convert(ReflectionUtils.invokeReadMethod(t, "id"), String.class);
      };
      this.cellFieldName = value;
   }

   public Function<T, String> getParseCellKeyFunc() {
      return this.parseCellKeyFunc;
   }

   public void setParseCellKeyFunc(Function<T, String> parseCellKeyFunc) {
      this.parseCellKeyFunc = parseCellKeyFunc;
   }

   public Function<T, String> getParseCellValueFunc() {
      return this.parseCellValueFunc;
   }

   public void setParseCellValueFunc(Function<T, String> parseCellValueFunc) {
      this.parseCellValueFunc = parseCellValueFunc;
   }

   public List<String> getPivotList() {
      return this.pivotList;
   }

   public void addPivot(String... pivots) {
      this.pivotList.addAll(ArrayUtils.asList(pivots));
   }

   public List<String> getExtList() {
      return this.extList;
   }

   public void addExt(String... exts) {
      this.extList.addAll(ArrayUtils.asList(exts));
   }

   public String getCellFieldName() {
      return this.cellFieldName;
   }

   public void setCellFieldName(String cellFieldName) {
      this.cellFieldName = cellFieldName;
   }

   public Function<T, String> getParseIdFunc() {
      return this.parseIdFunc;
   }
}
