/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.domain;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import net.sinodawn.framework.data.CaseInsensitiveLinkedMap;
import net.sinodawn.framework.json.jackson.JacksonCaseInsensitiveLinkedMapSerializer;
import org.springframework.data.annotation.Transient;

import java.util.Map;

public abstract class AbstractBaseData implements BaseData {
    @Transient
    private static final long serialVersionUID = -7205081622411099371L;
    @Transient
    @JsonSerialize(
            using = JacksonCaseInsensitiveLinkedMapSerializer.class
    )
    private final Map<String, String> ext$ = new CaseInsensitiveLinkedMap();

    public AbstractBaseData() {
    }

    public Map<String, String> getExt$() {
        return this.ext$;
    }

    public void setExt$(Map<String, String> ext$) {
        this.ext$.putAll(ext$);
    }

    public void setExt$Item(String key, String value) {
        this.ext$.put(key, value);
    }

    public String getExt$Item(String key) {
        return (String)this.ext$.get(key);
    }
}
