/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.base.bean;

import net.sinodawn.framework.support.domain.AbstractBaseData;
import org.springframework.data.annotation.Transient;

import java.io.Serializable;

public class CoreServiceStatusDTO extends AbstractBaseData implements Serializable {
   @Transient
   private static final long serialVersionUID = -5316024009848891139L;
   private AuditStatus auditStatus;
   private ActiveStatus activeStatus;
   private SuspendStatus suspendStatus;
   private String viewConfig;

   public AuditStatus getAuditStatus() {
      return this.auditStatus;
   }

   public void setAuditStatus(AuditStatus auditStatus) {
      this.auditStatus = auditStatus;
   }

   public ActiveStatus getActiveStatus() {
      return this.activeStatus;
   }

   public void setActiveStatus(ActiveStatus activeStatus) {
      this.activeStatus = activeStatus;
   }

   public SuspendStatus getSuspendStatus() {
      return this.suspendStatus;
   }

   public void setSuspendStatus(SuspendStatus suspendStatus) {
      this.suspendStatus = suspendStatus;
   }

   public String getViewConfig() {
      return this.viewConfig;
   }

   public void setViewConfig(String viewConfig) {
      this.viewConfig = viewConfig;
   }

   public static class SuspendStatus {
      private String lastSuspendedFlag;

      public String getLastSuspendedFlag() {
         return this.lastSuspendedFlag;
      }

      public void setLastSuspendedFlag(String lastSuspendedFlag) {
         this.lastSuspendedFlag = lastSuspendedFlag;
      }
   }

   public static class ActiveStatus {
      private String activatedFlag;

      public String getActivatedFlag() {
         return this.activatedFlag;
      }

      public void setActivatedFlag(String activatedFlag) {
         this.activatedFlag = activatedFlag;
      }
   }

   public static class AuditStatus {
      private String processStatus;
      private String statusCode;

      public String getProcessStatus() {
         return this.processStatus;
      }

      public void setProcessStatus(String processStatus) {
         this.processStatus = processStatus;
      }

      public String getStatusCode() {
         return this.statusCode;
      }

      public void setStatusCode(String statusCode) {
         this.statusCode = statusCode;
      }
   }
}
