/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.auditable.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.auditable.bean.CoreBpmnTaskStatusDTO;
import net.sinodawn.framework.support.auditable.service.GenericAuditableService;
import net.sinodawn.framework.support.domain.Auditable;
import java.io.Serializable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface GenericAuditableResource<S extends GenericAuditableService<T, ID>, T extends Auditable<ID>, ID extends Serializable> {
   S getService();

   @Log(
      value = "审核页查询",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/queries/tasks"},
      method = {RequestMethod.POST}
   )
   default Page<T> selectAuditablePagination(RestJsonWrapperBean wrapper) {
      return this.getService().selectAuditablePagination(wrapper);
   }

   @Log(
      value = "撤回页查询",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/queries/withdrawable"},
      method = {RequestMethod.POST}
   )
   default Page<T> selectWithdrawablePagination(RestJsonWrapperBean wrapper) {
      return this.getService().selectWithdrawablePagination(wrapper);
   }

   @Log(
      value = "回退页查询",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/queries/undoable"},
      method = {RequestMethod.POST}
   )
   default Page<T> selectUndoablePagination(RestJsonWrapperBean wrapper) {
      return this.getService().selectUndoablePagination(wrapper);
   }

   @Log(
      value = "工作流启动",
      type = LogType.PROCESS
   )
   @RequestMapping(
      value = {"/action/start-process"},
      method = {RequestMethod.PUT}
   )
   default void startProcess(RestJsonWrapperBean wrapper) {
      this.getService().startProcess(wrapper);
   }

   @Log(
      value = "工作流撤回",
      type = LogType.PROCESS
   )
   @RequestMapping(
      value = {"/action/withdraw-process"},
      method = {RequestMethod.PUT}
   )
   default void withdrawProcess(RestJsonWrapperBean wrapper) {
      this.getService().withdrawProcess(wrapper);
   }

   @Log(
      value = "工作流审核通过",
      type = LogType.PROCESS
   )
   @RequestMapping(
      value = {"/action/complete-task"},
      method = {RequestMethod.PUT}
   )
   default void completeTask(RestJsonWrapperBean wrapper) {
      this.getService().completeTask(wrapper);
   }

   @Log(
      value = "工作流转办",
      type = LogType.PROCESS
   )
   @RequestMapping(
      value = {"/action/transfer-task"},
      method = {RequestMethod.PUT}
   )
   default void transferTask(RestJsonWrapperBean wrapper) {
      this.getService().transferTask(wrapper);
   }

   @Log(
      value = "工作流结束",
      type = LogType.PROCESS
   )
   @RequestMapping(
      value = {"/action/end-task"},
      method = {RequestMethod.PUT}
   )
   default void endTask(RestJsonWrapperBean wrapper) {
      this.getService().endTask(wrapper);
   }

   @Log(
      value = "获取工作流任务节点的状态",
      type = LogType.PROCESS
   )
   @RequestMapping(
      value = {"/bpmn-task-status"},
      method = {RequestMethod.POST}
   )
   default CoreBpmnTaskStatusDTO selectBpmnTaskStatus(RestJsonWrapperBean wrapper) {
      return this.getService().selectBpmnTaskStatus(wrapper);
   }

   @Log(
      value = "工作流审核拒绝",
      type = LogType.PROCESS
   )
   @RequestMapping(
      value = {"/action/reject-task"},
      method = {RequestMethod.PUT}
   )
   default void rejectTask(RestJsonWrapperBean wrapper) {
      this.getService().rejectTask(wrapper);
   }

   @Log(
      value = "工作流异常拒绝",
      type = LogType.PROCESS
   )
   @RequestMapping(
      value = {"/action/odd-reject-task"},
      method = {RequestMethod.PUT}
   )
   default void oddRejectTask(RestJsonWrapperBean wrapper) {
      this.getService().oddRejectTask(wrapper);
   }

   @Log(
      value = "工作流回退",
      type = LogType.PROCESS
   )
   @RequestMapping(
      value = {"/action/undo"},
      method = {RequestMethod.PUT}
   )
   default void undo(RestJsonWrapperBean wrapper) {
      this.getService().undo(wrapper);
   }
}
