/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.auditable.resource;

import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.auditable.bean.CoreBpmnTaskStatusDTO;
import net.sinodawn.framework.support.domain.Auditable;
import java.io.Serializable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface GenericAuditableCloudResource<T extends Auditable<ID>, ID extends Serializable> {
   @RequestMapping(
      value = {"/queries/tasks"},
      method = {RequestMethod.POST}
   )
   Pagination<T> selectAuditablePagination(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/queries/undoable"},
      method = {RequestMethod.POST}
   )
   Pagination<T> selectUndoablePagination(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/start-process"},
      method = {RequestMethod.PUT}
   )
   void startProcess(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/withdraw-process"},
      method = {RequestMethod.PUT}
   )
   void withdrawProcess(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/complete-task"},
      method = {RequestMethod.PUT}
   )
   void completeTask(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/transfer-task"},
      method = {RequestMethod.PUT}
   )
   void transferTask(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/end-task"},
      method = {RequestMethod.PUT}
   )
   void endTask(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/bpmn-task-status"},
      method = {RequestMethod.POST}
   )
   CoreBpmnTaskStatusDTO selectBpmnTaskStatus(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/reject-task"},
      method = {RequestMethod.PUT}
   )
   void rejectTask(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/odd-reject-task"},
      method = {RequestMethod.PUT}
   )
   void oddRejectTask(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/undo"},
      method = {RequestMethod.PUT}
   )
   void undo(RestJsonWrapperBean wrapper);
}
