/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.support.auditable.resource;

import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.auditable.bean.CoreBpmnTaskStatusDTO;
import net.sinodawn.framework.support.auditable.service.GenericAuditableService;
import net.sinodawn.framework.support.domain.Auditable;
import java.io.Serializable;

public interface AbstractGenericAuditableResource<S extends GenericAuditableService<T, ID>, T extends Auditable<ID>, ID extends Serializable> extends GenericAuditableCloudResource<T, ID> {
   S getService();

   @Log(
      value = "审核页查询",
      type = LogType.SELECT
   )
   default Pagination<T> selectAuditablePagination(RestJsonWrapperBean wrapper) {
      return (Pagination)this.getService().selectAuditablePagination(wrapper);
   }

   @Log(
      value = "回退页查询",
      type = LogType.SELECT
   )
   default Pagination<T> selectUndoablePagination(RestJsonWrapperBean wrapper) {
      return (Pagination)this.getService().selectUndoablePagination(wrapper);
   }

   @Log(
      value = "工作流启动",
      type = LogType.PROCESS
   )
   default void startProcess(RestJsonWrapperBean wrapper) {
      this.getService().startProcess(wrapper);
   }

   @Log(
      value = "工作流撤回",
      type = LogType.PROCESS
   )
   default void withdrawProcess(RestJsonWrapperBean wrapper) {
      this.getService().withdrawProcess(wrapper);
   }

   @Log(
      value = "工作流审核通过",
      type = LogType.PROCESS
   )
   default void completeTask(RestJsonWrapperBean wrapper) {
      this.getService().completeTask(wrapper);
   }

   @Log(
      value = "工作流转办",
      type = LogType.PROCESS
   )
   default void transferTask(RestJsonWrapperBean wrapper) {
      this.getService().transferTask(wrapper);
   }

   @Log(
      value = "工作流结束",
      type = LogType.PROCESS
   )
   default void endTask(RestJsonWrapperBean wrapper) {
      this.getService().endTask(wrapper);
   }

   @Log(
      value = "获取工作流任务节点的状态需要认证",
      type = LogType.PROCESS
   )
   default CoreBpmnTaskStatusDTO selectBpmnTaskStatus(RestJsonWrapperBean wrapper) {
      return this.getService().selectBpmnTaskStatus(wrapper);
   }

   @Log(
      value = "工作流审核拒绝",
      type = LogType.PROCESS
   )
   default void rejectTask(RestJsonWrapperBean wrapper) {
      this.getService().rejectTask(wrapper);
   }

   @Log(
      value = "工作流异常拒绝",
      type = LogType.PROCESS
   )
   default void oddRejectTask(RestJsonWrapperBean wrapper) {
      this.getService().oddRejectTask(wrapper);
   }

   @Log(
      value = "工作流回退",
      type = LogType.PROCESS
   )
   default void undo(RestJsonWrapperBean wrapper) {
      this.getService().undo(wrapper);
   }
}
