/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.security.support;

import com.alibaba.fastjson.JSON;
import net.sinodawn.framework.security.exception.AccountOfflineException;
import net.sinodawn.framework.utils.ServletUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
@Primary
public class Http401UnauthorizedEntryPoint implements AuthenticationEntryPoint {
   private static final Logger logger = LogManager.getLogger(Http401UnauthorizedEntryPoint.class);
   @Autowired
   private RequestMappingHandlerMapping requestMappingHandlerMapping;

   public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
      logger.warn(exception.getMessage(), exception);
      String requestUri = ServletUtils.getRequestUri(request);
      Map<RequestMappingInfo, HandlerMethod> map = this.requestMappingHandlerMapping.getHandlerMethods();
      Iterator var6 = map.entrySet().iterator();

      while(var6.hasNext()) {
         Entry<RequestMappingInfo, HandlerMethod> m = (Entry)var6.next();
         RequestMappingInfo info = (RequestMappingInfo)m.getKey();
         HandlerMethod method = (HandlerMethod)m.getValue();
         PatternsRequestCondition p = info.getPatternsCondition();
         Iterator var11 = p.getPatterns().iterator();

         while(var11.hasNext()) {
            String url = (String)var11.next();
            if (requestUri.equals(url) && method.getMethod().getDeclaringClass().isAnnotationPresent(Controller.class)) {
               response.sendRedirect(ServletUtils.getContextPath() + "/");
               return;
            }
         }
      }

      Class<?> clazz = exception.getClass();
      if (AccountOfflineException.class.isAssignableFrom(clazz)) {
         ResponseStatus status = (ResponseStatus)clazz.getAnnotation(ResponseStatus.class);
         int httpStatus = status == null ? HttpStatus.GONE.value() : status.value().value();
         ServletUtils.responseMessage(response, httpStatus, exception.getMessage());
      } else {
         ServletUtils.responseMessage(response, JSON.toJSONString(Collections.singletonMap("message", "core.security.login.unauthorized")));
      }

   }
}
