/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.security.sso.impl;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.SinoAopContext;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.security.sso.SsoAuthenticator;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import org.springframework.security.crypto.password.PasswordEncoder;

public class TestLoginSsoAuthenticator implements SsoAuthenticator {
   public LoginUser authenticate() {
      String username = SinoAopContext.getCache("username");
      String password = SinoAopContext.getCache("password");
      CoreUserService userService = ApplicationContextHelper.getBean(CoreUserService.class);
      CoreUserBean user = userService.selectByLoginId(username);
      PasswordEncoder passwordEncoder = ApplicationContextHelper.getBean(PasswordEncoder.class);
      return user != null && user.getPassword().equals(passwordEncoder.encode(password)) ? new LoginUser(user.getId(), user.getPassword()) : null;
   }

   public boolean login() {
      return false;
   }
}
