/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.security.sso.impl;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.security.sso.SsoAuthenticator;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.sys.addomain.bean.CoreAdDomainUserBean;
import net.sinodawn.module.sys.addomain.service.CoreAdDomainUserService;
import net.sinodawn.module.sys.config.bean.CoreLoginConfigBean;
import net.sinodawn.module.sys.config.service.CoreLoginConfigService;
import org.springframework.security.authentication.BadCredentialsException;

import javax.naming.AuthenticationException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.servlet.http.HttpServletRequest;
import java.util.Hashtable;
import java.util.List;

public class AdDomainSsoAuthenticator implements SsoAuthenticator {
   private static final String ADDOMAIN_PROVIDER_URL_PREFIX = "ldap://";

   protected Hashtable<String, String> buildAdDomainAuthEnv(CoreLoginConfigBean loginConfig) {
      if (StringUtils.isEmpty(loginConfig.getAdDomainServer())) {
         throw new BadCredentialsException("CORE.MODULE.SYS.LOGIN_CONFIGS.AD_DOMAIN_SERVER_NOT_NULL");
      } else if (loginConfig.getAdDomainPort() == null) {
         throw new BadCredentialsException("CORE.MODULE.SYS.LOGIN_CONFIGS.AD_DOMAIN_PORT_NOT_NULL");
      } else {
         Hashtable<String, String> hashEnv = new Hashtable();
         String upnSuffix = StringUtils.isBlank(loginConfig.getAdDomainUpnSuffix()) ? "" : loginConfig.getAdDomainUpnSuffix();
         HttpServletRequest request = ServletUtils.getCurrentRequest();
         String username = "1".equals(loginConfig.getAdUserIdIgnoreCase()) ? StringUtils.lowerCase(request.getParameter("id")) + upnSuffix : request.getParameter("id") + upnSuffix;
         String rawPassword = request.getParameter("password");
         String password = AuthenticationHelper.getRawPassword(rawPassword);
         hashEnv.put("java.naming.security.authentication", "simple");
         hashEnv.put("java.naming.security.principal", username);
         hashEnv.put("java.naming.security.credentials", password);
         hashEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
         hashEnv.put("com.sun.jndi.ldap.connect.timeout", "3000");
         hashEnv.put("java.naming.provider.url", "ldap://" + loginConfig.getAdDomainServer() + ":" + loginConfig.getAdDomainPort());
         return hashEnv;
      }
   }

   protected LoginUser postAuthSuccessWithoutUser(CoreUserBean adUser) {
      throw new BadCredentialsException("CORE.SECURITY.AD_LOGIN.NO_USER_EXISTS");
   }

   public LoginUser authenticate() {
      CoreLoginConfigService loginConfigService = (CoreLoginConfigService)ApplicationContextHelper.getBean(CoreLoginConfigService.class);
      CoreLoginConfigBean loginConfig = loginConfigService.selectLoginConfig();
      Hashtable<String, String> hashEnv = this.buildAdDomainAuthEnv(loginConfig);
      InitialLdapContext ctx = null;

      try {
         ctx = new InitialLdapContext(hashEnv, (Control[])null);
      } catch (AuthenticationException var19) {
         throw new BadCredentialsException("SINO.SECURITY.LOGIN.INCORRECT_USER_OR_PASSWORD");
      } catch (Exception var20) {
         throw new UnexpectedException(var20);
      } finally {
         if (ctx != null) {
            try {
               ctx.close();
            } catch (Exception var18) {
            }
         }

      }

      String adUserId = ServletUtils.getCurrentRequest().getParameter("id");
      if ("1".equals(loginConfig.getAdUserIdIgnoreCase())) {
         adUserId = StringUtils.lowerCase(adUserId);
      }

      CoreAdDomainUserService adUserService = (CoreAdDomainUserService)ApplicationContextHelper.getBean(CoreAdDomainUserService.class);
      CoreAdDomainUserBean filter = new CoreAdDomainUserBean();
      filter.setAdUserId(adUserId);
      List<CoreAdDomainUserBean> adDomainUserList = adUserService.selectList(filter, new Order[0]);
      if (!adDomainUserList.isEmpty()) {
         CoreAdDomainUserBean adDomainUser = (CoreAdDomainUserBean)adDomainUserList.get(0);
         CoreUserService userService = (CoreUserService)ApplicationContextHelper.getBean(CoreUserService.class);
         CoreUserBean user = (CoreUserBean)userService.selectByIdIfPresent(adDomainUser.getId());
         LoginUser loginUser = new LoginUser(user.getId(), user.getPassword());
         loginUser.setAdditionalCheck(false);
         return loginUser;
      } else {
         CoreUserBean user = new CoreUserBean();
         user.setId(adUserId);
         this.postAuthSuccessWithoutUser(user);
         return null;
      }
   }
}
