/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.security.sso;

import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.utils.ClassUtils;
import java.util.HashMap;
import java.util.Map;

public enum SsoAuthenticatorRegistry {
   INSTANCE;

   private Map<String, SsoAuthenticator> REPOSITORY = new HashMap();

   public void register(String key, Class<? extends SsoAuthenticator> clazz) {
      this.REPOSITORY.put(key, ClassUtils.newInstance(clazz));
   }

   public SsoAuthenticator getAuthenticator(String key) {
      return (SsoAuthenticator)this.REPOSITORY.get(key);
   }

   public void checkLoginUser(LoginUser loginUser) {
      this.REPOSITORY.forEach((k, v) -> {
         v.checkLoginUser(loginUser);
      });
   }
}
