/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.security.schedule;

import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.module.sys.log.bean.CoreLoginLogBean;
import net.sinodawn.module.sys.log.service.CoreLoginLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;

@Repository
public class AuthenticationExpiredSchedule {
   @Autowired
   private CoreLoginLogService loginLogService;

   @Scheduled(
      fixedDelay = 30000L
   )
   public void schedule() {
      SinoConcurrentLocker.isolatedRun("SECDURITY_ONLINE_TESTING_SCHEDULE", () -> {
         CoreLoginLogBean filter = (CoreLoginLogBean)BeanUtils.getPropertyListenerProxy(CoreLoginLogBean.class);
         filter.setStatus("1");
         filter.setLogoutTime((LocalDateTime)null);
         List<CoreLoginLogBean> loginLogList = this.loginLogService.selectList(filter, new Order[0]);
         if (!loginLogList.isEmpty()) {
            Iterator var3 = loginLogList.iterator();

            while(var3.hasNext()) {
               CoreLoginLogBean loginLog = (CoreLoginLogBean)var3.next();
               Authentication authentication = AuthenticationHelper.getCacheAuthentication(loginLog.getToken());
               if (authentication == null) {
                  this.loginLogService.assignLogout(loginLog.getToken(), I18nHelper.getMessage("SINO.SECURITY.LOGIN.TIMEOUT"));
               }
            }
         }

      });
   }
}
