/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.security.bean;

import net.sinodawn.framework.utils.CollectionUtils;
import org.springframework.data.annotation.Transient;
import org.springframework.security.core.userdetails.User;

public class LoginUser extends User {
   @Transient
   private static final long serialVersionUID = -4330491852385170523L;
   private String orgId;
   private String orgName;
   private Long roleId;
   private String roleName;
   private String casToken;
   private boolean additionalCheck = true;

   public LoginUser(String username, String password) {
      super(username, password, CollectionUtils.emptyList());
   }

   public String getOrgId() {
      return this.orgId;
   }

   public void setOrgId(String orgId) {
      this.orgId = orgId;
   }

   public String getOrgName() {
      return this.orgName;
   }

   public void setOrgName(String orgName) {
      this.orgName = orgName;
   }

   public Long getRoleId() {
      return this.roleId;
   }

   public void setRoleId(Long roleId) {
      this.roleId = roleId;
   }

   public String getRoleName() {
      return this.roleName;
   }

   public void setRoleName(String roleName) {
      this.roleName = roleName;
   }

   public boolean getAdditionalCheck() {
      return this.additionalCheck;
   }

   public void setAdditionalCheck(boolean additionalCheck) {
      this.additionalCheck = additionalCheck;
   }

   public String getCasToken() {
      return this.casToken;
   }

   public void setCasToken(String casToken) {
      this.casToken = casToken;
   }
}
