/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.restful.resolver.wrapper;

import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ToRestJsonWrapperResolver implements HandlerMethodArgumentResolver {
   public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer container, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
      ToRestJsonWrapperResolveArgumentHandler resolveArgumentHandler = new ToRestJsonWrapperResolveArgumentHandler(parameter, webRequest);
      return resolveArgumentHandler.supports() ? resolveArgumentHandler.resolveArgument() : RestJsonWrapperBean.EMPTY;
   }

   public boolean supportsParameter(MethodParameter parameter) {
      return parameter.getParameterType().equals(RestJsonWrapperBean.class);
   }
}
