/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.restful.resolver.wrapper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.restful.data.RestFieldValueTextContainer;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.resolver.AbstractJsonResolveArgumentHandler;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ToRestJsonWrapperResolveArgumentHandler extends AbstractJsonResolveArgumentHandler<RestJsonWrapperBean> {
   public ToRestJsonWrapperResolveArgumentHandler(MethodParameter parameter, NativeWebRequest webRequest) {
      super(parameter, webRequest);
   }

   public boolean supports() {
      HttpServletRequest request = (HttpServletRequest)this.getWebRequest().getNativeRequest(HttpServletRequest.class);
      return !"GET".equals(request.getMethod()) && StringUtils.contains(request.getContentType(), "application/json");
   }

   public RestJsonWrapperBean resolveArgument() {
      String requestJson = this.getRequestJson();
      if (StringUtils.isEmpty(requestJson)) {
         return new RestJsonWrapperBean();
      } else {
         JSONObject jo = this.convertRequestJson(requestJson);
         String converterJson = jo.toJSONString();
         Map<String, String> paramMap = new HashMap();
         String paramStr = jo.getString("p");
         if (!StringUtils.isEmpty(paramStr)) {
            JSONObject paramObject = JSONObject.parseObject(paramStr);
            paramObject.entrySet().stream().forEach((e) -> {
               String var10000 = (String)paramMap.put(e.getKey(), ConvertUtils.convert(e.getValue(), String.class));
            });
            String t = (String)paramMap.get("t");
            if (!StringUtils.isEmpty(t)) {
               this.setValueTextContainer(t);
            }
         }

         List<List<String>> bodyList = new ArrayList();
         List<GenericService<?, ?>> bodyServiceList = new ArrayList();
         int index = 0;

         while(true) {
            JSONArray array = jo.getJSONArray("b" + (index > 0 ? index : ""));
            if (array == null || array.isEmpty()) {
               return new RestJsonWrapperBean(converterJson, paramMap, bodyList, bodyServiceList);
            }

            String serviceName = array.getString(0);
            JSONArray contentArray = array.getJSONArray(1);
            if (contentArray != null && !contentArray.isEmpty()) {
               List<String> contentList = (List)contentArray.stream().map((a) -> {
                  return ((JSONObject)a).toJSONString();
               }).collect(Collectors.toList());
               bodyList.add(contentList);
               if (StringUtils.isEmpty(serviceName)) {
                  bodyServiceList.add(null);
               } else if (StringUtils.contains(serviceName, "_")) {
                  bodyServiceList.add(ApplicationContextHelper.getServiceByTable(serviceName));
               } else {
                  bodyServiceList.add(ApplicationContextHelper.getBean(serviceName));
               }
            }

            ++index;
         }
      }
   }

   private void setValueTextContainer(String tJson) {
      JSONObject tjo = JSONObject.parseObject(tJson);
      RestFieldValueTextContainer valueTextContainer = RestFieldValueTextContainer.getInstance();
      tjo.forEach((k, v) -> {
         JSONObject vjo = (JSONObject)v;
         String type = vjo.getString("type");
         String items = vjo.getString("items");
         if (items == null) {
            valueTextContainer.addFieldData(k, type);
         } else {
            Map<String, String> valueTextMap = new HashMap();
            JSONArray ija = JSONObject.parseArray(items);
            int i = 0;

            for(int j = ija.size(); i < j; ++i) {
               JSONObject ijo = (JSONObject)ija.get(i);
               valueTextMap.put(ijo.getString("value"), ijo.getString("text"));
            }

            valueTextContainer.addFieldData(k, type, valueTextMap);
         }

      });
      HttpServletRequest request = (HttpServletRequest)this.getWebRequest().getNativeRequest(HttpServletRequest.class);
      request.setAttribute("SINO_RFVTC", valueTextContainer);
   }

   private JSONObject convertRequestJson(String requestJson) {
      JSONObject jo = JSONObject.parseObject(requestJson);
      String json = jo.getString("requestJson");
      return !StringUtils.isBlank(json) ? JSONObject.parseObject(json) : jo;
   }
}
