/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.restful.resolver.string;

import net.sinodawn.framework.restful.resolver.AbstractJsonResolveArgumentHandler;
import net.sinodawn.framework.utils.StringUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

public class ToJsonStringResolveArgumentHandler extends AbstractJsonResolveArgumentHandler<String> {
   public ToJsonStringResolveArgumentHandler(MethodParameter parameter, NativeWebRequest webRequest) {
      super(parameter, webRequest);
   }

   public boolean supports() {
      HttpServletRequest request = (HttpServletRequest)this.getWebRequest().getNativeRequest(HttpServletRequest.class);
      return !"GET".equals(request.getMethod()) && StringUtils.contains(request.getContentType(), "application/json");
   }

   public String resolveArgument() {
      return this.getRequestJson();
   }
}
