/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.restful.resolver;

import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public abstract class AbstractJsonResolveArgumentHandler<T> {
   private final MethodParameter parameter;
   private final NativeWebRequest webRequest;

   public AbstractJsonResolveArgumentHandler(MethodParameter parameter, NativeWebRequest webRequest) {
      this.parameter = (MethodParameter)Objects.requireNonNull(parameter);
      this.webRequest = (NativeWebRequest)Objects.requireNonNull(webRequest);
   }

   public MethodParameter getParameter() {
      return this.parameter;
   }

   public NativeWebRequest getWebRequest() {
      return this.webRequest;
   }

   protected String getRequestJson() {
      if (!this.supports()) {
         return null;
      } else {
         HttpServletRequest request = (HttpServletRequest)this.getWebRequest().getNativeRequest(HttpServletRequest.class);

         try {
            InputStream is = request.getInputStream();
            Throwable var3 = null;

            String var4;
            try {
               var4 = StringUtils.read(is);
            } catch (Throwable var14) {
               var3 = var14;
               throw var14;
            } finally {
               if (is != null) {
                  if (var3 != null) {
                     try {
                        is.close();
                     } catch (Throwable var13) {
                        var3.addSuppressed(var13);
                     }
                  } else {
                     is.close();
                  }
               }

            }

            return var4;
         } catch (IOException var16) {
            throw new UnexpectedException(var16);
         }
      }
   }

   public abstract boolean supports();

   public abstract T resolveArgument();
}
