/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.restful.data;

import net.sinodawn.framework.utils.ServletUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

public class RestFieldValueTextContainer {
   public static final String HTTP_SERVLET_REQUEST_ATTRIBUTE_KEY = "SINO_RFVTC";
   public List<FieldData> fieldDataList = new ArrayList();

   private RestFieldValueTextContainer() {
   }

   public static RestFieldValueTextContainer getInstance() {
      return new RestFieldValueTextContainer();
   }

   public static String getText(String field, String value) {
      HttpServletRequest request = ServletUtils.getCurrentRequest();
      if (request == null) {
         return value;
      } else {
         RestFieldValueTextContainer container = (RestFieldValueTextContainer)request.getAttribute("SINO_RFVTC");
         if (container == null) {
            return value;
         } else {
            FieldData fieldData = (FieldData)container.fieldDataList.stream().filter((f) -> {
               return f.getField().equalsIgnoreCase(field);
            }).findFirst().orElse(null);
            return fieldData == null ? value : fieldData.getText(value);
         }
      }
   }

   public void addFieldData(String field, String type) {
      this.fieldDataList.add(new FieldData(field, type));
   }

   public void addFieldData(String field, String type, Map<String, String> valueTextMap) {
      this.fieldDataList.add(new FieldData(field, type, valueTextMap));
   }

   private static enum FieldType {
      SELECT,
      CHECKBOX;
   }

   private static class FieldData {
      private final String field;
      private final FieldType type;
      private final Map<String, String> valueTextMap;

      public FieldData(String field, String type) {
         this(field, type, null);
      }

      public FieldData(String field, String type, Map<String, String> valueTextMap) {
         this.type = (FieldType)Arrays.stream(FieldType.values()).filter((t) -> {
            return t.name().equalsIgnoreCase(type);
         }).findAny().get();
         this.field = field;
         if (valueTextMap == null) {
            this.valueTextMap = new HashMap();
            if (FieldType.CHECKBOX.equals(this.type)) {
               this.valueTextMap.put("0", "SINO.CHECKBOX.UNCHECKED");
               this.valueTextMap.put("1", "SINO.CHECKBOX.CHECKED");
            }
         } else {
            this.valueTextMap = valueTextMap;
         }

      }

      public String getField() {
         return this.field;
      }

      public String getText(String value) {
         return (String)this.valueTextMap.get(value);
      }
   }
}
