/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.restful;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.Cookie;
import java.util.ArrayList;
import java.util.List;

@Component
public class RestHelper {
   private static RestTemplate restTemplate;

   @Autowired
   public void setRestTemplate(RestTemplate restTemplate) {
      RestHelper.restTemplate = restTemplate;
   }

   public static <T> T getForObject(String url, Class<T> requiredClass, Cookie... cookies) {
      HttpHeaders headers = new HttpHeaders();
      List<String> cookieList = new ArrayList<>();

      for (Cookie c : cookies) {
         cookieList.add(c.getName() + "=" + c.getValue());
      }

      headers.put("Cookie", cookieList);
      HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
      ResponseEntity<T> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity, requiredClass);
      return responseEntity.getBody();
   }
}
