/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.mybatis.page;


import net.sinodawn.framework.data.page.Pageable;
import net.sinodawn.framework.utils.NumberUtils;
import org.apache.ibatis.session.RowBounds;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@SuppressWarnings("unused")
public class PageRowBounds extends RowBounds {
    private int total;
    private int pageNumber;
    private String[] sumProperties;
    private String[] countProperties;
    private Map<String, Number> totalMap;

    public PageRowBounds(Pageable pageable) {
        super(NumberUtils.parseInt(pageable.getOffset()), pageable.getPageSize());
        this.pageNumber = pageable.getPageNumber();
        this.sumProperties = pageable.getSumProperties();
        this.countProperties = pageable.getCountProperties();
    }

    public Map<String, Number> getTotalMap() {
        return Optional.ofNullable(this.totalMap).orElse(new HashMap<>());
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setTotalMap(Map<String, Number> totalMap) {
        this.totalMap = new HashMap<>(totalMap);
        if (this.totalMap.containsKey("QTY_")) {
            this.total = NumberUtils.parseInt(this.totalMap.get("QTY_"));
        }

    }

    public String[] getSumProperties() {
        return Optional.ofNullable(this.sumProperties).orElse(new String[0]);
    }

    public void setSumProperties(String... sumProperties) {
        this.sumProperties = sumProperties;
    }

    public String[] getCountProperties() {
        return Optional.ofNullable(this.countProperties).orElse(new String[0]);
    }

    public void setCountProperties(String[] countProperties) {
        this.countProperties = countProperties;
    }
}
