/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.mybatis.page;


import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MybatisPageHelper {
    private static final ThreadLocal<String> LOCAL_BIND_FLAG = new ThreadLocal();
    private static final ThreadLocal<PageRowBounds> LOCAL_PAGE_CONTAINER = new ThreadLocal();
    private static final ThreadLocal<Map<String, String>> LOCAL_COLUMN_TYPE_CONTAINER = new ThreadLocal();

    public MybatisPageHelper() {
    }

    public static void bind(PageRowBounds rowBounds) {
        LOCAL_PAGE_CONTAINER.set(rowBounds);
    }

    public static PageRowBounds getBindPageRowBounds() {
        return (PageRowBounds)LOCAL_PAGE_CONTAINER.get();
    }

    public static boolean isBind() {
        return LOCAL_BIND_FLAG.get() != null;
    }

    public static boolean isBindPageRowBounds() {
        return LOCAL_PAGE_CONTAINER.get() != null;
    }

    public static void setColumnTypeMap(Map<String, String> map) {
        Map<String, String> container = new HashMap();
        map.forEach((k, v) -> {
            container.put(k.toLowerCase(), getRevisedColumnType(v));
        });
        LOCAL_COLUMN_TYPE_CONTAINER.set(container);
    }

    public static void clearPage() {
        LOCAL_PAGE_CONTAINER.remove();
    }

    public static void clear() {
        LOCAL_BIND_FLAG.remove();
        LOCAL_PAGE_CONTAINER.remove();
        LOCAL_COLUMN_TYPE_CONTAINER.remove();
    }

    public static <T> Page<T> get(PageRowBounds rowBounds, Supplier<List<T>> supplier) {
        Pagination var4;
        try {
            LOCAL_BIND_FLAG.set("1");
            if (rowBounds != null) {
                bind(rowBounds);
            }

            List<T> list = (List)supplier.get();
            Pagination page;
            if (rowBounds != null) {
                page = new Pagination(rowBounds, list);
                page.setColumnTypeMap((Map)LOCAL_COLUMN_TYPE_CONTAINER.get());
                var4 = page;
                return var4;
            }

            page = new Pagination(list);
            page.setColumnTypeMap((Map)LOCAL_COLUMN_TYPE_CONTAINER.get());
            var4 = page;
        } finally {
            clear();
        }

        return var4;
    }

    public static <T extends Persistable<?>> Page<T> get(Class<T> type, PageRowBounds rowBounds, Supplier<List<Map<String, Object>>> supplier) {
        Pagination var6;
        try {
            if (rowBounds != null) {
                bind(rowBounds);
            }

            List<Map<String, Object>> mapList = (List)supplier.get();
            Pagination page;
            if (mapList.isEmpty()) {
                if (rowBounds == null) {
                    page = new Pagination();
                    page.setColumnTypeMap((Map)LOCAL_COLUMN_TYPE_CONTAINER.get());
                    page = page;
                    return page;
                }

                page = new Pagination(rowBounds, CollectionUtils.emptyList());
                page.setColumnTypeMap((Map)LOCAL_COLUMN_TYPE_CONTAINER.get());
                page = page;
                return page;
            }

            List<T> itemList = (List)mapList.stream().map((m) -> {
                return (Persistable) PersistableHelper.mapToPersistable(m, type);
            }).collect(Collectors.toList());
            if (rowBounds == null) {
                page = new Pagination(itemList);
                page.setColumnTypeMap((Map)LOCAL_COLUMN_TYPE_CONTAINER.get());
                var6 = page;
                return var6;
            }

            page = new Pagination(rowBounds, itemList);
            page.setColumnTypeMap((Map)LOCAL_COLUMN_TYPE_CONTAINER.get());
            var6 = page;
        } finally {
            clear();
        }

        return var6;
    }

    private static String getRevisedColumnType(String columnType) {
        byte var2 = -1;
        switch(columnType.hashCode()) {
            case 2374300:
                if (columnType.equals("Long")) {
                    var2 = 0;
                }
                break;
            case 798274969:
                if (columnType.equals("LocalDate")) {
                    var2 = 2;
                }
                break;
            case 1153828870:
                if (columnType.equals("LocalDateTime")) {
                    var2 = 3;
                }
                break;
            case 2052876273:
                if (columnType.equals("Double")) {
                    var2 = 1;
                }
        }

        switch(var2) {
            case 0:
            case 1:
                return "number";
            case 2:
                return "date";
            case 3:
                return "dateTime";
            default:
                return "string";
        }
    }
}
