/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.mybatis.mapper;


import net.sinodawn.framework.utils.ObjectUtils;

import java.util.*;

@SuppressWarnings({"unused","unchecked"})
public class SearchFilter {
    public Map<String, Object> filterMap = new HashMap<>();
    public List<FilterParamPattern> stdFilterList = new ArrayList<>();

    private SearchFilter() {
    }

    public static <V> SearchFilter instance() {
        return new SearchFilter();
    }

    /**
     * 设置过滤器依据字段及其值
     * @param key 过滤依据字段
     * @param value 过滤值
     * @param <V> 值类型
     * @return 过滤器匹配器
     */
    public <V> SearchFilter.Matcher<V> match(String key, V value) {
        return new SearchFilter.Matcher<>(this, key, value);
    }

    public <V> SearchFilter.Matcher<V> match(String[] keys, V value) {
        return new SearchFilter.Matcher<>(this, keys, value);
    }

    public Map<String, Object> getFilterMap() {
        return Collections.unmodifiableMap(this.filterMap);
    }

    public List<FilterParamPattern> getStdFilterList() {
        return Collections.unmodifiableList(this.stdFilterList);
    }

    public static class Matcher<V> {
        private final SearchFilter filter;
        private final String[] keys;
        private final V value;

        public Matcher(SearchFilter filter, String key, V value) {
            this.filter = filter;
            this.value = value;
            this.keys = new String[]{key};
        }

        public Matcher(SearchFilter filter, String[] keys, V value) {
            this.filter = filter;
            this.value = value;
            this.keys = keys;
        }

        /**
         * 设置过滤器过滤规则
         * @param match 匹配规则（枚举值）
         * @return 过滤器
         */
        public SearchFilter filter(MatchPattern match) {
            Map<String, Object> map = new IdentityHashMap<>();
            String[] var3 = this.keys;
            int var4 = var3.length;

            for (String key : var3) {
                if (this.value != null && List.class.isAssignableFrom(this.value.getClass())) {
                    ((List<Object>) this.value).forEach((v) -> map.put(ObjectUtils.clone(key), v));
                } else {
                    map.put(key, this.value);
                }
            }

            this.filter.stdFilterList.add(new FilterParamPattern(match.name(), map));
            return this.filter;
        }

        public SearchFilter special() {

            for (String key : this.keys) {
                this.filter.filterMap.put(key, this.value);
            }

            return this.filter;
        }
    }
}
