/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.mybatis.mapper;


import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;

@SuppressWarnings("unchecked")
public enum MatchPattern {
    /**
     * 字符串左对齐
     */
    SB(String.class),
    /**
     * 字符串居中对齐
     */
    SC(String.class),
    /**
     * 字符串右对齐
     */
    SE(String.class),
    SEQ(String.class),
    /**
     * 字符串不区分大小写左对齐
     */
    CISB(String.class),
    CISC(String.class),
    CISE(String.class),
    CISEQ(String.class),
    /**
     * 日期大于
     */
    DG(LocalDate.class),
    DGOE(LocalDate.class),
    DL(LocalDate.class),
    DLOE(LocalDate.class),
    /**
     * 日期相等，只比较年月日
     */
    DEQ(LocalDate.class),
    DR(LocalDate.class),
    TG(LocalDateTime.class),
    TGOE(LocalDateTime.class),
    TL(LocalDateTime.class),
    TLOE(LocalDateTime.class),
    TEQ(LocalDateTime.class),
    TR(LocalDateTime.class),
    NG(Double.class),
    NGOE(Double.class),
    NL(Double.class),
    NLOE(Double.class),
    NEQ(Double.class),
    NR(Double.class),
    /**
     * Equal
     */
    EQ(Void.class),
    /**
     * 不相等
     */
    DIFFER(Void.class),
    /**
     * 特殊条件
     */
    SPECIAL(String.class),
    MULTIPLE(String.class),
    NOR(Double.class),
    DOR(LocalDate.class),
    TOR(LocalDateTime.class),
    OR(String.class),
    CBM(String.class),
    /** @deprecated */
    @Deprecated
    IN(String.class);

    private Class<?> type;

    private MatchPattern(Class<?> type) {
        this.type = type;
    }

    public <T> T parse(Object value) {
        return Void.class.equals(this.type) ? (T) value : (T)ConvertUtils.convert(value, this.type);
    }

    public static MatchPattern getPatternIfPossible(String pattern) {
        return StringUtils.isEmpty(pattern) ? null : Arrays.stream(values()).filter((p) -> p.name().equals(pattern)).findAny().orElse(null);
    }
}
