/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.mybatis.mapper;

import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyEvent;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.beans.BeanPropertyListener;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import org.springframework.data.annotation.Transient;
import org.springframework.data.util.Pair;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("unused")
public class MapperParameter extends HashMap<String, Object> {
   @Transient
   private static final long serialVersionUID = -5846726410121110379L;

   public MapperParameter() {
   }

   public MapperParameter(int initialCapacity) {
      super(initialCapacity);
   }

   public MapperParameter(Map<? extends String, ? extends Object> m) {
      super(m);
   }

   public MapperParameter(int initialCapacity, float loadFactor) {
      super(initialCapacity, loadFactor);
   }

   public void setTableName(String tableName) {
      this.put("STD_TABLENAME", tableName);
   }

   public void setRawQueries() {
      this.put("queries_raw", "1");
   }

   public void setSearchableQueries() {
      this.put("queries_searchable", "1");
   }

   public void setAuditableQueries() {
      this.put("queries_auditable", "1");
   }

   public void setChoosableQueries() {
      this.put("queries_choosable", "1");
   }

   public void setSelectableQueries() {
      this.put("queries_selectable", "1");
   }

   public void setSuspendableQueries() {
      this.put("queries_suspendable", "1");
   }

   public void setUndoableQueries() {
      this.put("queries_undoable", "1");
   }

   public void setWithdrawableQueries() {
      this.put("queries_withdrawable", "1");
   }

   public void setFilter(SearchFilter filter) {
      if (!filter.getFilterMap().isEmpty()) {
         this.putAll(filter.getFilterMap());
      }

      if (!filter.getStdFilterList().isEmpty()) {
         FilterParamPattern[] patterns = (FilterParamPattern[])((FilterParamPattern[])this.get("filterParamPatterns"));
         if (patterns == null) {
            patterns = new FilterParamPattern[0];
         }

         this.put("filterParamPatterns", ArrayUtils.concat(patterns, filter.getStdFilterList().toArray(new FilterParamPattern[0])));
      }

   }

   public <T extends Persistable<?>> void setFilter(List<T> itemList, String... filterColumns) {
      if (!itemList.isEmpty() && filterColumns.length > 0) {
         List<Map<String, Object>> mapList = new ArrayList<>();

         for (T item : itemList) {
            Map<String, Object> map = new HashMap<>();
            if (!ArrayUtils.isEmpty(filterColumns)) {
               int var12 = filterColumns.length;

               for (String filterColumn : filterColumns) {
                  map.put(filterColumn, BeanUtils.getPropertyValue(item, filterColumn));
               }
            } else {
               List propertyDescriptorList;
               if (BeanPropertyListener.class.isAssignableFrom(item.getClass())) {
                  propertyDescriptorList = ((BeanPropertyListener) item).getChangedPropertyEventList();
                  propertyDescriptorList.forEach((e) -> map.put(((BeanPropertyEvent) e).getName(), ((BeanPropertyEvent) e).getNewValue()));
               } else {
                  propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(ClassUtils.getRawType(item.getClass()));

                  for (Object o : propertyDescriptorList) {
                     BeanPropertyDescriptor pd = (BeanPropertyDescriptor) o;
                     Object value = pd.getPropertyValue(item);
                     if (value != null) {
                        map.put(pd.getName(), value);
                     }
                  }

                  map.putAll(item.getExt$());
               }
            }

            if (!map.isEmpty()) {
               mapList.add(map);
            }
         }

         this.put("filter_by_item_list", mapList);
      }

   }

   public void setSuspendedFlag(String lastSuspendedFlag) {
      SearchFilter filter = SearchFilter.instance().match("lastSuspendedFlag", lastSuspendedFlag).filter(MatchPattern.EQ);
      this.setFilter(filter);
   }

   public void setProcessStatus(String processStatusColumn, ProcessStatus status) {
      SearchFilter filter = SearchFilter.instance();
      switch(status) {
         case DRAFT:
         case DRAFT_REJECTED:
            filter.match(processStatusColumn, ProcessStatus.DRAFT.name().toLowerCase()).filter(MatchPattern.SB);
            break;
         case APPROVE:
         case APPROVE_REJECTED:
            filter.match(processStatusColumn, ProcessStatus.APPROVE.name().toLowerCase()).filter(MatchPattern.SB);
            break;
         case DONE:
            filter.match(processStatusColumn, ProcessStatus.DONE.name().toLowerCase()).filter(MatchPattern.SEQ);
            break;
         default:
            filter.match(processStatusColumn, status.name().toLowerCase()).filter(MatchPattern.SPECIAL);
      }

      this.setFilter(filter);
   }

   public void setActivatedFlag(String activatedFlag) {
      SearchFilter filter = SearchFilter.instance().match("activatedFlag", activatedFlag).filter(MatchPattern.EQ);
      this.setFilter(filter);
   }

   public void setAuthorityParameter(String authority) {
      this.put("authority_" + authority, "1");
   }

   public void setAuditAuthority() {
      this.setAuthorityParameter("audit");
   }

   public void setOrgAuthority() {
      this.setAuthorityParameter("org");
   }

//   public void setCurrentAndChildOrgAuthority(String orgColumn) {
//      CoreOrgService orgService = (CoreOrgService)ApplicationContextHelper.getBean(CoreOrgService.class);
//      List<CoreOrgBean> childOrgList = orgService.selectChildOrgList(LocalContextHelper.getLoginOrgId());
//      List<String> permittedOrgIdList = (List)childOrgList.stream().map(CoreOrgBean::getId).collect(Collectors.toList());
//      SearchFilter filter = SearchFilter.instance();
//      if (permittedOrgIdList.isEmpty()) {
//         filter.match(orgColumn, LocalContextHelper.getLoginOrgId()).filter(MatchPattern.EQ);
//      } else {
//         permittedOrgIdList.add(LocalContextHelper.getLoginOrgId());
//         filter.match(orgColumn, permittedOrgIdList).filter(MatchPattern.OR);
//      }
//
//      this.setFilter(filter);
//   }

   public void setOrderParam(String name, String direction) {
      List<Pair<String, String>> orderParamList = (List)this.get("orderParams");
      if (orderParamList == null) {
         orderParamList = new ArrayList();
      }

      ((List)orderParamList).add(Pair.of(name, direction));
      this.put("orderParams", orderParamList);
   }

   public void setSelectByRoleIdParam(Long roleId) {
      this.put("select_by_roleId", roleId);
   }

   public void setSelectByRoleIdExclusiveParam(Long roleId) {
      this.put("select_by_roleId_exclusive", roleId);
   }
}
