/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.mybatis.mapper;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@Mapper
public interface GlobalMapper {
    void update(@Param("sql") String sql);

    List<Map<String, Object>> selectListBySqlList(@Param("sqlList") List<String> sqlList);

    List<Map<String, Object>> selectList(@Param("sql") String sql);

    Map<String, Object> selectOne(@Param("sql") String sql);

    List<String> selectColumnList(@Param("tableName") String tableName);

    LocalDateTime selectDatabaseTime();

    void callNextSequenceProcedure(Map<String, Object> map);

    LocalDateTime selectSubmittedTime(@Param("auditedTable") String auditedTable, @Param("id") String id);

    String selectOneString(@Param("sql") String sql);
}
