/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.mybatis.mapper;


import net.sinodawn.framework.utils.*;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.IdentityHashMap;
import java.util.Map;

public class FilterParamPattern {
    private final Map<String, Object> map = new IdentityHashMap<>();
    private String matchPattern;

    public FilterParamPattern(String matchPattern, String key, Object value) {
        this.matchPattern = matchPattern;
        this.map.put(key.toUpperCase(), value);
    }

    public FilterParamPattern(String matchPattern, Map<String, Object> map) {
        this.matchPattern = matchPattern;
        map.forEach((k, v) -> this.map.put(k.toUpperCase(), v));
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public void setMatchPattern(String matchPattern) {
        this.matchPattern = matchPattern;
    }

    public boolean match(Map<String, Object> targetMap) {
        if (MatchPattern.SB.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch(
                (e) -> StringUtils.startsWith(ObjectUtils.toString(CollectionUtils.getValueIgnorecase(targetMap, e.getKey())), (String)e.getValue())
            );
        } else if (MatchPattern.SC.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> StringUtils.contains(ObjectUtils.toString(CollectionUtils.getValueIgnorecase(targetMap, e.getKey())), (String)e.getValue()));
        } else if (MatchPattern.SE.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> StringUtils.endsWith(ObjectUtils.toString(CollectionUtils.getValueIgnorecase(targetMap, e.getKey())), String.valueOf(e.getValue())));
        } else if (MatchPattern.SEQ.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> StringUtils.equals(ObjectUtils.toString(CollectionUtils.getValueIgnorecase(targetMap, e.getKey())), (String)e.getValue()));
        } else if (MatchPattern.CISB.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> StringUtils.startsWithIgnoreCase(ObjectUtils.toString(CollectionUtils.getValueIgnorecase(targetMap, e.getKey())), (String)e.getValue()));
        } else if (MatchPattern.CISC.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> StringUtils.containsIgnoreCase(ObjectUtils.toString(CollectionUtils.getValueIgnorecase(targetMap, e.getKey())), (String)e.getValue()));
        } else if (MatchPattern.CISE.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> StringUtils.endsWithIgnoreCase(ObjectUtils.toString(CollectionUtils.getValueIgnorecase(targetMap, e.getKey())), (String)e.getValue()));
        } else if (MatchPattern.CISEQ.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> StringUtils.equalsIgnoreCase(ObjectUtils.toString(CollectionUtils.getValueIgnorecase(targetMap, e.getKey())), (String)e.getValue()));
        } else if (MatchPattern.DG.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> DateTimeUtils.isAfter(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDate.class), ConvertUtils.convert(e.getValue(), LocalDate.class)));
        } else if (MatchPattern.DGOE.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().noneMatch((e) -> DateTimeUtils.isBefore(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDate.class), ConvertUtils.convert(e.getValue(), LocalDate.class)));
        } else if (MatchPattern.DL.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> DateTimeUtils.isBefore(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDate.class), ConvertUtils.convert(e.getValue(), LocalDate.class)));
        } else if (MatchPattern.DLOE.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().noneMatch((e) -> DateTimeUtils.isAfter(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDate.class), ConvertUtils.convert(e.getValue(), LocalDate.class)));
        } else if (MatchPattern.DEQ.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().noneMatch((e) -> DateTimeUtils.isEqual(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDate.class), ConvertUtils.convert(e.getValue(), LocalDate.class)));
        } else if (MatchPattern.DOR.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().anyMatch((e) -> !DateTimeUtils.isEqual(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDate.class), ConvertUtils.convert(e.getValue(), LocalDate.class)));
        } else if (MatchPattern.TG.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> DateTimeUtils.isAfter(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDateTime.class), ConvertUtils.convert(e.getValue(), LocalDateTime.class)));
        } else if (MatchPattern.TGOE.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().noneMatch((e) -> DateTimeUtils.isBefore(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDateTime.class), ConvertUtils.convert(e.getValue(), LocalDateTime.class)));
        } else if (MatchPattern.TL.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> DateTimeUtils.isBefore(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDateTime.class), ConvertUtils.convert(e.getValue(), LocalDateTime.class)));
        } else if (MatchPattern.TLOE.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().noneMatch((e) -> DateTimeUtils.isAfter(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDateTime.class), ConvertUtils.convert(e.getValue(), LocalDateTime.class)));
        } else if (MatchPattern.TEQ.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().noneMatch((e) -> DateTimeUtils.isEqual(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDateTime.class), ConvertUtils.convert(e.getValue(), LocalDateTime.class)));
        } else if (MatchPattern.TOR.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().anyMatch((e) -> !DateTimeUtils.isEqual(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), LocalDateTime.class), ConvertUtils.convert(e.getValue(), LocalDateTime.class)));
        } else if (MatchPattern.NG.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> NumberUtils.isGreater(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), Double.class), ConvertUtils.convert(e.getValue(), Double.class)));
        } else if (MatchPattern.NGOE.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().noneMatch((e) -> NumberUtils.isLess(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), Double.class), ConvertUtils.convert(e.getValue(), Double.class)));
        } else if (MatchPattern.NL.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> NumberUtils.isLess(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), Double.class), ConvertUtils.convert(e.getValue(), Double.class)));
        } else if (MatchPattern.NLOE.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().noneMatch((e) -> NumberUtils.isGreater(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), Double.class), ConvertUtils.convert(e.getValue(), Double.class)));
        } else if (MatchPattern.NEQ.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().allMatch((e) -> ObjectUtils.equals(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), Double.class), ConvertUtils.convert(e.getValue(), Double.class)));
        } else if (MatchPattern.NOR.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().anyMatch((e) -> ObjectUtils.equals(ConvertUtils.convert(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), Double.class), ConvertUtils.convert(e.getValue(), Double.class)));
        } else if (MatchPattern.EQ.name().equals(this.getMatchPattern())) {
            // 相等
            return this.map.entrySet().stream().allMatch(
                (e) -> ObjectUtils.equals(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), e.getValue())
            );
        } else if (MatchPattern.DIFFER.name().equals(this.getMatchPattern())) {
            return this.map.entrySet().stream().noneMatch((e) -> ObjectUtils.equals(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), e.getValue()));
        } else if (!MatchPattern.OR.name().equals(this.getMatchPattern()) && !MatchPattern.IN.name().equals(this.getMatchPattern())) {
            return MatchPattern.CBM.name().equals(this.getMatchPattern()) && this.map.entrySet().stream().allMatch((e) -> StringUtils.contains(ObjectUtils.toString(CollectionUtils.getValueIgnorecase(targetMap, e.getKey())), (String) e.getValue()));
        } else {
            return this.map.entrySet().stream().anyMatch((e) -> ObjectUtils.equals(CollectionUtils.getValueIgnorecase(targetMap, e.getKey()), e.getValue()));
        }
    }
}
